/*
 *	jQuery Clone v1.7
 *
 *	Copyright (c) 2014 Michael Cook
 *	Released under the MIT license:
 *  http://www.opensource.org/licenses/mit-license.php
 */

(function($){
	$.fn.extend({
		cloneElement: function(options) {

			var defaults = {
				callback: function() {},
				remove_disabled_attr: true,
				confirmMessage: '',
				ajaxCall: false // if true, use the clone__delete href as ajax call
			}

			var options = $.extend(defaults, options);

			$(document).on('click', '.clone__add', function (e) {
				//e.preventDefault();

				if (options.ajaxCall == true) {
					$.ajax({
						'url': $(this).attr('href')
					});
				}


			//$(this).click(function() { // only works with clone(true, true)
				var clone = $(this).closest('.clone');
				var parent = clone.parent();

				// reveal hidden original clone
				if (clone.hasClass('clone__hidden')) {

					revealClone(clone);
				} else {

					cloneMe(clone);
				}

				//unused - clones can always be deleted
				//handleDisability(clone, parent);
				options.callback.call(this);
			});

			// apply to all delete buttons
			$(document).on('click', '.clone__delete', function () {

				var $delInput;
                if ($delInput = $(this).parents('.clone-zone').find('.deleteInput').first()) {
                        var deleteID = $(this).parents('.clone').find('.id').val();
                        $delId = $delInput.clone();
                        $delId.attr('id', '');
                        $delId.val(deleteID);
                        $delInput.after($delId);
                }

				var accept = true;
				if (options.confirmMessage != '') {
					var accept = false;
					if (confirm(options.confirmMessage)) accept = true;
				}

				if (accept == true) {
					var clone = $(this).closest('.clone');
					var parent = clone.parent();
					var numClones = clone.parent().find('.clone').length;
					//console.log(numClones)
					if (numClones>1) {
						deleteClone(clone);
					}
					else if (numClones==1) {
						hideClone(clone);
					}
					var clone = $(this).closest('.clone'); // find a remaining clone for reference

					//unused - clones can always be deleted
					//handleDisability(clone, parent);
				}
			});

			function cloneMe(element) {
				//var twin = element.clone(true, true); // clone with events
				var twin = element.clone(false, false); // clone without events


				// Give the created clone a data attribute signifying it's index
				var cloneID = parseInt(twin.attr('data-clone'))+1;
				if (!twin.attr('data-clone'))
					twin.attr('data-clone', 1);
				else
					twin.attr('data-clone', cloneID);

				// Append all the names, ids and fors for form elements with their clone index
				// i.e. name='data[label][0][field]' would become name='data[Label][1][Field]'
				twin.find('input, select, textarea').each(function() {
					var name = $(this).attr('name'); // e.g. 'data[Label][1][Field]'

					// strip down to 'Label,1,Field', then split into array.
					name = name.replace('data', '')
								.replace(/\]\[/g, ',')
								.replace(/\[/g, '')
								.replace(/\]/g, '');
					//var name__split = name.match(/\[(.*?)\]/);

					var name__split = name.split(',');

					// recreate the attribute with clone index (ignoring whatever [0] style index it has)
					if (name__split) {
						name = 'data';
						var id = '';

						var incremented = false;
						for (i=0; i<name__split.length; i++) {

							// increase only the first numeric value, e.g.
							// data[Label][2][Sub][0]
							if (incremented == false) {
								if ($.isNumeric(name__split[i])) {
									name__split[i] ++;
									incremented = true;
								}
							}
							name += '[' + (name__split[i]) + ']';
						}

						// ID is same as name but stripped out data and []
						id = name.replace(/[\[\]]/g, '');
						if (id.substr(0,4)=='data') {
							id = id.substr(4, id.length);
						}

						// if a hidden input, append the id with an underscore
						if ($(this).attr('type') == 'hidden') {
							id += '_';
						}

						// set the name attribute
						$(this).attr('name', name);

						// set the id
						$(this).attr('id', id);

						// set the label sibling label's 'for' attribute
						if ($(this).parent().find('label').length) {
							$(this).parent().find('label').attr('for', id);
						}
					}
				});

				blankValues(twin);

				/*
				 * If adding a delete clone section:
				 * Say there are various clones - 1, 2, 3, 4
				 * Deleting 3 would leave 1, 2, 4.
				 * You'd think it would need to shift all the proceeding values
				 * However, cakePHP doesn't mind as it just iterates through things anyway
				 * and it would cause more problems than it solves
				 */

				/*
				// changed to apply to all delete buttons (at top)
				twin.find('.clone__delete').click(function() {
					var clone = $(this).closest('.clone');
					//var cloneID = parseInt(clone.attr('data-clone'))+1;
					deleteClone(clone);
				})
				*/

				// Place the cloned copy after the original
				element.after(twin);

				//twin = element.next('.twin');

				// Leave the add button only on the newest clone
				if (element.find('.clone__add').length) element.find('.clone__add').remove();
			}

			function blankValues(clone) {
				// Blank the values for inputs, selects and textareas
				clone.find('input, select, textarea').each(function() {
					$(this).val('');

					// check for disabled values and check options and process accordingly
					if (options.remove_disabled_attr && $(this).attr('disabled') == 'disabled') {

						$(this).removeAttr('disabled');
					}
				});

				/*
				 * Add Support for form element jquery plugins such as
				 * customSelect, datepicker, autogrow, validate
				 *
				 */

				// Remove any extranous form function classes such, i.e. hasSomething
				clone.find('input').removeClass('hasDatepicker');
				clone.find('select').removeClass('hasCustomSelect');

				// Remove any extraneous html (such as that generated by customSelect)
				clone.find('span.customSelect').remove();
				clone.find('.error-message').remove();

				// add support for file uploads
				clone.find('div.customFile, .customFileButton').remove();

				// Extract select from customSelect wrapper and strip
				clone.find('.customSelectWrapper > *').unwrap().removeAttr('style');

				// Remove extraneous styles from form functions such as autogrow
				//twin.find('.autogrow').height('auto');
				clone.find('.autogrow').removeAttr('style');

				// add support for tinyMCE
				// This has issues, it doesn't destroy and reinitialise properly, hopefully moving to Redactor
				//clone.find('.mce-tinymce').parent().find('textarea').removeAttr('aria-hidden').show().parent().find('.mce-tinymce').remove();

				// Remove ALL tinymce things, don't forget to reinitialise
				$('.hasTinyMCE').each(function() {
					tinymce.remove($(this).attr('id'));
					$(this).removeClass('hasTinyMCE');
				});

				//tinyMCEdiv = clone.find('textarea.mce-tinymce');
				clone.find('textarea.wysiwyg, textarea.mce-tinymce').each(function() {
					//tinymce.execCommand('mceRemoveControl', true, $(this).attr('id'));

					$(this).removeAttr('aria-hidden').show().parent().find('div.mce-tinymce').remove();
				});

			}

			function deleteClone(clone) {
				//c(cloneID);
				// if necessary, clone the add button to the previous clone element
				if (clone.find('.clone__add').length && clone.prev('.clone').length) {
					var prev = clone.prev('.clone');

					prev.append(clone.find('.clone__add'));
				}
				clone.remove();
			}


			function hideClone(clone) {
				// Blank values, then disable all the inputs and hide the element ready to be reappeared
				blankValues(clone);

				clone.find('input, select, textarea').prop('disabled', true);

				clone.addClass('clone__hidden')

				// in, perhaps few cases, we need to hide everything other than the clone__add button
				if (clone.find('.clone__add').length) {
					var cloneAdd = clone.find('.clone__add');
					// hide all clone children, but reveal clone__add and it's ancestors up to clone
					clone.children('*').hide();
					cloneAdd.show();
					cloneAdd.closest('.clone').show();

					// replace 'Another' with 'An'
					cloneAdd.find('span.clone__add__text').html(cloneAdd.data('noclone-label'));
				}
				else clone.hide();

				// Also hide the header row
				if (clone.closest('form').length && clone.closest('form').find('th').length) {
					clone.closest('form').find('th').parent().hide();
				}
			}

			function revealClone(clone) {
				clone.removeClass('clone__hidden');

				clone.find('input, select, textarea').prop('disabled', false);

				// in, perhaps few cases, we need to hide everything other than the clone__add button
				if (clone.find('.clone__add').length) {
					var cloneAdd = clone.find('.clone__add');
					// hide all clone children, but reveal clone__add and it's ancestors up to clone
					clone.children('*').hide();
					cloneAdd.show();
					cloneAdd.closest('.clone').show();

					// replace 'An' with 'Another', etc
					cloneAdd.find('span.clone__add__text').html(cloneAdd.data('clone-label'));
				}

				clone.show();
				clone.children('*').show();

				// Also reveal the header row
				if (clone.closest('form').length && clone.closest('form').find('th').length) {
					clone.closest('form').find('th').parent().show();
				}
			}

			// only stylistically
			function handleDisability(clone, parent) {
				//var cloneID = parseInt(clone.attr('data-clone'))+1;
				var numClones = parent.find('.clone').length;
				//c(numClones)

				parent.find('.clone__delete').removeClass('disabled');
				if (numClones<2) {
					//$(this).addClass('disabled'); // this clone gets deleted..
					parent.find('.clone__delete').addClass('disabled');
				}
			}
		}
	});
})(jQuery);
