<?php
/**
 * This view template isn't intended for production use. Instead it is here to 
 * help guide you to develop your own product view template.
 * 
 * To override this template create a new template file at:-
 * 
 * 		app/View/Plugin/EvShop/Products/view.ctp
 */

	echo $this->Html->tag('h2', $data['Product']['name']);
	echo $this->Html->para(null, __('Product code') . ': ' . $data['Product']['SKU']);

	$items = array();
	if (!empty($data['RelatedBrand'][0])) {
		$items[] = $this->Html->link(
			$data['RelatedBrand'][0]['name'], 
			array(
				'plugin' => 'ev_shop', 
				'controller' => 'products', 
				'action' => 'index', 
				'brand' => $data['RelatedBrand'][0]['id']
			)
		);
	}
	if (!empty($data['RelatedCategory'])) {
		$items[] = $this->Html->link(
			$data['RelatedCategory'][0]['name'],
			array(
				'plugin' => 'ev_shop', 
				'controller' => 'products', 
				'action' => 'index', 
				'category' => $data['RelatedCategory'][0]['id']
			)
		);
	}
	if (!empty($data['Product']['lead_time'])) {
		$items[] = $data['Product']['lead_time'];
	}
	echo $this->Html->nestedList($items);

	echo $this->Html->para(null, $data['Product']['description']);

	// Include form for adding items to the basket.
	echo $this->Form->create();

	// Important! Make sure the form sets Form.process to 'EvShop.add_to_basket'
	// to ensure that it gets processed.
	echo $this->Form->hidden('Form.process', array('value' => 'EvShop.add_to_basket'));

	echo $this->Form->input('Product.id');

	echo $this->Form->input('OrderItem.quantity', array('type' => 'number', 'min' => 1, 'default' => 1));

	// Options
	foreach ($productAttributes as $key => $productAttribute) {

		echo $this->Form->label(
			'ProductAttribute' . $productAttribute['ProductAttribute']['id'], 
			$productAttribute['ProductAttribute']['name']
		);

		$options = array();
		foreach ($productAttribute['ProductAttributeOption'] as $productAttributeOption) {
			$options[] = $this->Html->tag(
				'option',
				$productAttributeOption['name'],
				array(
					'value' => $productAttributeOption['id'],
					'data-cost' => $productAttributeOption['min_price'],
					'data-rrp' => $productAttributeOption['min_rrp'],
					'data-stock' => $productAttributeOption['stock'],
					'data-product-variant-id' => $productAttributeOption['product_variant_id']
				)
			);
		}
		echo $this->Html->tag(
			'select',
			implode("\n", $options),
			array(
				'name' => 'data[ProductVariant][ProductAttributeOption]' . $key,
				'id' => 'ProductAttribute' . $productAttribute['ProductAttribute']['id'],
				'data-attribute-id' => $productAttribute['ProductAttribute']['id']
			)
		);

	}

	echo $this->Form->submit(__('Add to Basket'));

	echo $this->Form->end();

	// Include any related products
	if (!empty($relatedProducts)) {

		echo $this->Html->tag('h2', __('Related Products'));
		foreach ($relatedProducts as $key => $product) {
			echo $this->Element('EvShop.Product/ProductBox', compact('product'));
		}

	}