<?php

App::uses('EvShopAppModel', 'EvShop.Model');

class Brand extends EvShopAppModel {

	public $actsAs = array(
		'MetaData.Meta',
		'Routable.Routable' => array(
			'alias' => 'brand/:displayField',
			'actual' => 'ev_shop/products/index/brand::primaryKey'
		)
	);

	public $hasMany = array(
		'Product' => array(
			'className' => 'EvShop.Product'
		)
	);

	public $imageSlots = array(
		'main' => array(
			'fields' => array(
				'alt'
			),
			'slots' => 1
		),
		'listing' => array(
			'fields' => array(
				'alt'
			),
			'slots' => 1
		)
	);

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Category name is mandatory'
			),
			'unique' => array(
				'rule' => 'isUnique',
				'message' => 'Category name must be unique'
			)
		)
	);

}
