<?php

App::uses('EvShopAppController', 'EvShop.Controller');

/**
 * Product Attribute App Controller
 *
 * @package EvShop/ProductAttribute
 */
class ProductAttributesController extends EvShopAppController {

	public function admin_edit($id = null) {
		$ProductAttribute = $this->{$this->modelClass};

		//Using the clone function need to remove any that have been marked for deletion
		if (isset($this->request->data['delete'])) {

			foreach ($this->request->data['delete'] as $association => $val) {

					$ProductAttribute->$association->deleteAll(array(
							$association . '.id' => array_values($val)
					));

			}

		}

		parent::admin_edit($id);

		$this->view = 'EvShop.ProductAttributes/admin_form';
	}

/**
 * Defines the fields displayed in an admin_form for this model
 *
 * Defaults to all fields in the db table
 *
 * Override in your controller to customise
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		unset($fields['is_primary']);

		return $fields;
	}

/**
 * Defines the fields displayed in a filter form.
 *
 * Defaults to id, display name, is_active, created and modified fields.
 *
 * Override in your controller to customise.
 *
 * Format:
 *
 * 'id' => array(
 *         'label' => label text,
 *         'type' => data type of control
 *         'compare' => SQL query. e.g. Model.field='%s' (where %s is replace by the value of the field)
 *         'default' => value you want the data filtering by by default
 * )
 */
	protected function _adminFilterFields() {
		return array();
	}

}
