var variantOptions = [];
var selectedVariants = [];

$(document).ready(function() {
	//Sort out the bootstrap column classes on certain elements
	//Currency inputs and labels
	var currencyInputs = $('input[data-type=currency]');
	currencyInputs.parent().removeClass('col-md-9 col-sm-10');
	currencyInputs.parent().addClass('col-md-6 col-sm-6');

	currencyInputs.parent().prev().removeClass('col-md-3 col-sm-2');
	currencyInputs.parent().prev().addClass('col-md-6 col-sm-6');

	//stock options
	var multiChecks = $('.manage-stock-options .form-group-multicheck');
	multiChecks.parent().removeClass('col-sm-9');
	multiChecks.parent().prev().removeClass('col-sm-3');
	multiChecks.parent().prev().addClass('col-md-12');

	// Bulk-pricing updater
	$('.variant-modal-remove-price').on('click', function(){
		var currentButton = $(this);
		removePrice(currentButton);
	});

	// Loop through all the variant records and get an array of their options
	$('fieldset.variant-record').each(function(e) {
		var optionList = $(this).attr('data-options').split(',');
		variantOptions[$(this).attr('data-variant')] = optionList;
	});

	$('input[type=checkbox].variant-option-selector').on('change', function() {
		selectedVariants = [];
		rebuildSelectedVariants();
	});

	$('.variant-modal-save').on('click', function() {
		updateSelectedVariants();
		resetVariantModal();

		$('#bulkUpdateModal').find('.modal-loading').fadeIn('fastest').delay(1000).closest('#bulkUpdateModal').modal('hide').find('.modal-loading').fadeOut('fastest');


	});

	// Virtual tax field generation
	$('input[data-type=currency]').each(function(e) {
		if ($(this).attr('data-taxrate') > 0 && $(this).attr('data-field') != 'trade_price') {

			var thisInput = $(this);
			var inputParent = thisInput.parents('.form-group');

			var cloned = inputParent.clone();
			cloned.addClass('taxed');

			cloned.find('input').attr('data-type', 'currency-taxed');
			cloned.find('input').attr('name', 'taxed_' + $(this).attr('name'));
			cloned.find('.display-info').remove();

			if (cloned.find('input').attr('data-taxlabel') == true) {
				cloned.find('label').html('inc. VAT');
			} else {
				cloned.find('label').html('inc. VAT');
			}

			// assign the cloned element to the DOM
			inputParent.after(cloned);

			if ($(this).val() > 0) {
				cloned.find('input').val(calculateTax($(this)));
			}

			// attach keyup event listener
			$(this).on('change keyup', function() {
				if ($(this).val() !== '') {
					cloned.find('input').val(calculateTax($(this)));
				} else {
					cloned.find('input').val('');
				}
			});

			// attach keyup event listener to the cloned input
			cloned.find('input').on('change keyup', function() {
				if ($(this).val() !== '') {
					thisInput.val(calculateReverseTax(cloned.find('input')));
				} else {
					thisInput.val('');
				}
			});
		}
	});
});


function calculateTax(input) {
	var taxRate = '1.' + parseInt(input.attr('data-taxrate'));
	var value = input.val();
	var taxedValue = value * taxRate;
	taxedValue = (Math.round(taxedValue * 100) / 100).toFixed(2);

	return taxedValue;
}

function calculateReverseTax(input) {
	var taxRate = '1.' + parseInt(input.attr('data-taxrate'));
	var value = input.val();
	var untaxedValue = (value / taxRate).toFixed(3);

	if (untaxedValue.toString()[untaxedValue.length - 1] == 0) {
		untaxedValue = parseFloat(untaxedValue).toFixed(2);
	} else {
		untaxedValue = parseFloat(untaxedValue)
	}

	return untaxedValue;

}

function rebuildSelectedVariants() {

	var selectedOptions = [];
	var selectedOptionGroups = [];

	$('input[type=checkbox].variant-option-selector').each(function() {
		if ($(this).prop('checked')) {
			//Get the group this current option is in
			var optionGroupName = $(this).closest('fieldset').attr('data-option-group');

			if (selectedOptions[optionGroupName] == undefined) {
				selectedOptions[optionGroupName] = [];
				selectedOptionGroups.push(optionGroupName);
			}

			selectedOptions[optionGroupName].push($(this).attr('data-option'));
		}
	});

	// Recalculate selected variants
	$('fieldset.variant-record').each(function(e) {
		var optionList = $(this).attr('data-options').split(',');

		var selectedItems = [];
		//For each option in a selected group, check that at least 1 option matches with the current variant
		$.each(selectedOptionGroups, function(index, optionGroupKey) {
			var currentOptions = selectedOptions[optionGroupKey];

			$.each(currentOptions, function(index, optionId) {
				if ($.inArray(optionId, optionList) !== -1) {
					//This selected option is in this variant, select this variant. Any other options from this group don't matter
					selectedItems.push(optionId);
				}
			});
		});

		if(selectedItems.length == selectedOptionGroups.length && jQuery.inArray($(this).attr('data-variant'), selectedVariants) == -1) {
			selectedVariants.push($(this).attr('data-variant'));
		} else {
			selectedVariants = jQuery.grep(selectedVariants, function (value) {
				return value != $(this).attr('data-variant');
			})
		}
	});

	//if no options from any group are selected.
	if(selectedOptionGroups.length <= 0) {
		selectedVariants = [];
	}

	// update total display
	// $('.totalApplicableVariants').parent().fadeOut(150).fadeIn(150).fadeOut(150).fadeIn(150);
	$('.totalApplicableVariants').parent().fadeOut(150).fadeIn(150);
	$('.totalApplicableVariants').html(selectedVariants.length);
}

function updateSelectedVariants() {
	// get a master list of the bulk-update values to use
	var rrpList = [];
	var priceList = [];
	var salePriceList = [];
	var tradePriceList = [];

	$('#bulkUpdateModal').find('input[data-type=currency]').each(function() {
		var newPrice = $(this).val();
		if (newPrice == 'REMOVE') {
			newPrice = null;
		}

		if ($(this).attr('data-field') == 'rrp') {
			rrpList[$(this).attr('data-currency')] = newPrice;
		} else if ($(this).attr('data-field') == 'price') {
			priceList[$(this).attr('data-currency')] = newPrice;
		} else if ($(this).attr('data-field') == 'sale_price') {
			salePriceList[$(this).attr('data-currency')] = newPrice;
		} else if ($(this).attr('data-field') == 'trade_price') {
			tradePriceList[$(this).attr('data-currency')] = newPrice;
		}
	});

	$('fieldset.variant-record').each(function(e) {

		var variantId = $(this).attr('data-variant');

		if(jQuery.inArray(variantId, selectedVariants) !== -1) {
			$(this).find('input[data-type=currency]').each(function() {
				var updatedPrice;
				if ($(this).attr('data-field') == 'rrp') {
					if (updatePriceField(rrpList[$(this).attr('data-currency')])) {
						updatedPrice = rrpList[$(this).attr('data-currency')];
						$(this).val(updatedPrice);
					}
				} else if ($(this).attr('data-field') == 'price') {
					if (updatePriceField(priceList[$(this).attr('data-currency')])) {
						updatedPrice = priceList[$(this).attr('data-currency')];
						$(this).val(updatedPrice);
					}
				} else if ($(this).attr('data-field') == 'sale_price') {
					if (updatePriceField(salePriceList[$(this).attr('data-currency')])) {
						updatedPrice = salePriceList[$(this).attr('data-currency')];
						$(this).val(updatedPrice);
					}
				} else if ($(this).attr('data-field') == 'trade_price') {
					if (updatePriceField(tradePriceList[$(this).attr('data-currency')])) {
						updatedPrice = tradePriceList[$(this).attr('data-currency')];
						$(this).val(updatedPrice);
					}
				}

				//Trigger the change event so if VAT values are displayed they can be updated
				if (updatedPrice === null) {
					$(this).parent().siblings('.taxed').find('input[data-type="currency-taxed"]').val(null);
				} else if (updatedPrice !== undefined) {
					$(this).trigger('change');
				}

			});
		}
	});
}

function updatePriceField(value) {
	var update = true;

	if (value === undefined || value == '') {
		update = false;
	}
	return update;
}

function removePrice(currentButton) {
	if (currentButton.hasClass('btn-danger')) {
		//Set the button and input values to removal
		var previousValue = currentButton.parent().prev('.form-group').find('input[data-type="currency"]').val();
		currentButton.parent().prev('.form-group').find('input[data-type="currency"]').val('REMOVE');
		currentButton.parent().prev('.form-group').find('input[data-type="currency"]').prop('disabled', true);
		currentButton.parent().prev('.form-group').find('input[data-type="currency-taxed"]').prop('disabled', true);
		currentButton.parent().prev('.form-group').find('input[data-type="currency-taxed"]').val(null);

		currentButton.removeClass('btn-danger');
		currentButton.addClass('btn-primary');

		currentButton.html('Add Price');
		currentButton.attr('data-previous-value', previousValue);
	} else {
		//Reset the button and input values
		var previousValue = currentButton.attr('data-previous-value');
		resetBulkUpdateModalPrice(currentButton, previousValue);
	}
}

function resetBulkUpdateModalPrice(currentButton, previousValue) {
	//Reset the button and input values
	currentButton.parent().prev('.form-group').find('input[data-type="currency"]').val(previousValue);
	currentButton.parent().prev('.form-group').find('input[data-type="currency"]').prop('disabled', false);
	currentButton.parent().prev('.form-group').find('input[data-type="currency-taxed"]').prop('disabled', false);
	console.log(previousValue);
	if (previousValue !== undefined && previousValue !== null && previousValue !== '') {
		currentButton.parent().prev('.form-group').find('input[data-type="currency"]').trigger('change');
	}

	currentButton.removeClass('btn-primary');
	currentButton.addClass('btn-danger');

	currentButton.html('Remove Price');
	currentButton.attr('data-previous-value', null);
}

function resetBulkUpdateModalPrices() {
	$('.variant-modal-remove-price').each(function() {
		var currentButton = $(this);
		resetBulkUpdateModalPrice(currentButton, null);
	});
}

function resetVariantModal() {
	$('#bulkUpdateModal').find('input[type=checkbox]').prop('checked', false);
	$('#bulkUpdateModal').find('input[data-type=currency]').val(null);
	$('#bulkUpdateModal').find('input[data-type=currency-taxed]').val(null);

	resetBulkUpdateModalPrices();
}
