# EvShop

## Installation

Simply add EvShop to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvShop`.

The installer will automatically setup the database tables, add all the needed menu links to the admin, create the templates needed to display the pages and finally create the pages needed for the brands / category / products listing screens and automatically create and save the `ev_shop` config.

## How it works

### Shop Core

The bulk of the shop is handled via the brands, categories and products components which are used to retrieve the paginated listing of each section. The standard shop format is setup within the bundled controllers but using these components will allow you to add listings to other sections of a site.

All pages also run using the template system, basic templates for all of these are bundled with the plugin that should show all the available variables. If for some reason a template doesn't exist the shop will fallback and use a more basic "fallback template" also bundled with the plugin.

### Option Groups / Options

Option groups and options work on a global basis in that they are added separately from products. Products then simply retrieve the full list of options ready for the user to select. Simply means that alot of work can be cut down for a user as they won't have to manually enter options for every product.

Options are also not directly tied to a product, options only ever get tagged to a variant so we can keep a check of which options make up each variant.

### Variants

To help keep the code simple, variants are always used regardless of whether any options are ticked for the product or whether they are disabled or not.

Doing this allows us to keep the plugin simple, it means that each product will always have a least 1 variant.

If it's from a product that was tagged to options, these options will then also be tagged to the variant so that we may identify which options each variant is made up of.

####Bulk Variant Price Updater
From version 2.2.2.0 the plugin now has a bulk update tool to allow staff to update a number of variant's pricing at once. This is quite simply just a glorified javascript file that pulls data from data attributes and then updates records based on what options were selected.

This tool only shows if the showVariants config variable is set to true, as it's not got any purpose on single-variant sites.

In addition if the 'autoManageCurrencies' config option is set to true, it'll only show pricing for the default currency as other currencies will be automatically updated by the currency plugin upon saving.

To use version 2.2.2.0 of the shop you need to be using an up to date copy of core-cms that contains the bootstrap bridge.

### Variant Rebuilding

The system attempts to be clever with when it rebuilds the variants as in doing so, **it may cause you to lose SKU / Pricing data**. To help minimise the risk of losing data the system tries to detect when an option from an option group has been added or removed before rebuilding.

e.g. If we previously had selected Colour group options of Red and Blue and Size group options of Regular and Large we would have 4 variants created

* Red Regular
* Red Large
* Blue Regular
* Blue Large

Upon selecting another colour, we simply need to create another 2 variants linking the new colour to each size so the existing variants are left as they are.

Whereas adding 2 options of Wood and Metal from the Type option group would require the rebuilding of all the current options as there is no longer `Red Regular` as we have now `Red Regular Wood` and `Red Regular Metal`.

Similarly, if the two Type options were removed, we would have to rebuild all variants again as `Red Regular Wood` and `Red Regular Metal` would no longer be options.

###Trade Pricing
EvShop supports custom trade pricing, however this will not be displayed as default.

Firstly there is a site setting (SiteSetting.ev_shop.enable_trade_pricing) to globally enable/disable the trade account support in EvShop. This needs to be enabled.

To display trade pricing to your customers instead of the list pricing, a temporary session called 'EvShop.isTrade' should be set with a value of true.

This will then be used to return trade prices instead of the standard (or sale) price.

This would then basically be used on a per-site basis. For example you might just have an is_trade flag on a customer record. Then you extend your existing login functionality to set that session if they are logged in and have the is_trade flag.

This could have been done as a hard-coded check in EvShop but keeping it as a session seems like a better option as it's then not tied to a field on a specific table, and can be used on the fly.

Tax will still be applied to trade prices as standard, however this can be disabled using a site setting called 'SiteSetting.ev_shop.disable_tax_on_trade_pricing

## Setup

Setup is relatively simple for a standard E-Commerce setup. As default, Variants and brands are active and all that will need setting overriding in the config are the ID numbers for the brand, category, product listing pages. This is so on the main landing page for each of those section SEO meta data can be applied. This should however be handled by the installer as mentioned above.

## Extending / Using

### Default Setup

As default, the shop plugin will automatically build up a breadcrumb trail and assign to the templates. Assuming `EvTax` is retrieved from composer, each product and variant will have Tax set up for usage, as well as each variant having an inventory row created within EvInventory (again if included via composer).

For full documentation on extending controllers, see the Core Documentation

#### Database EER

A full model of the EvShop database can be found in the `_db` directory at the root of the plugin. Please maintain the diagram when making changes to the database schema.

### Products Listing and Helpers

### Searching with product listing
If you want to search with the product listing method in the ProductsComponent then you will need to extend it and override the `_addAdditionalParamsToListing`.

If you are using the Evoluted Search plugin https://git.evoluted.net/evoluted-core-plugins/searchable then the following examples can be used to access the search index table through the listing.

First you will need to add an extra virtual field by extendig the ProductsComponent and overriding `_addVirtualFieldsToProductListing`:

	protected function _addVirtualFieldsToProductListing(&$Model, $orderData) {
		parent::_addVirtualFieldsToProductListing($Model, $orderData);

		if (isset($orderData['search']) && !empty($orderData['search'])) {
			$searchTerm = $orderData['search']['searchTerm'];
			$Model->virtualFields['relevance'] = "((MATCH(SearchIndex.data) AGAINST ('\"$searchTerm\"' IN BOOLEAN MODE) * 10)
				+ (MATCH(SearchIndex.data) AGAINST ('$searchTerm' IN BOOLEAN MODE) * 1.5))";
		}

		return;
	}

You will then need to add a join and order parameter to the listing query by overriding the `_addAdditionalParamsToListing`:

	protected function _addAdditionalParamsToListing(&$queryModel, $currentParams, $orderData) {
		//Go through the passed ordering parameters and add it to the pagination query
		$currentParams = parent::_addAdditionalParamsToListing($queryModel, $currentParams, $orderData);

		if (isset($orderData['search']) && !empty($orderData['search'])) {
			$currentParams = $this->_addSearchParamsToListing($currentParams, $orderData['search'], $queryModel);
		}

		return $currentParams;
	}

	protected function _addSearchParamsToListing($currentParams, $orderOptions, &$queryModel) {
		$searchTerm = $orderOptions['searchTerm'];

		$currentParams['joins'][] = [
			'table' => 'search_indices',
			'alias' => 'SearchIndex',
			'conditions' => [
				'SearchIndex.model' => 'EvShop.Product',
				'SearchIndex.association_key = Product.id',
				'OR' => [
					"MATCH(SearchIndex.data) AGAINST('\"$searchTerm\"' IN BOOLEAN MODE) > 0",
					"MATCH(SearchIndex.data) AGAINST('$searchTerm' IN BOOLEAN MODE) > 0"
				]
			]
		];

		if (isset($currentParams['order'])) {
			$currentParams['order'] .= ', Product.relevance DESC';
		} else {
			$currentParams['order'] = 'Product.relevance DESC';
		}

		return $currentParams;
	}

Then you will need to call the component and pass the search term in the order data as `['search']['searchTerm']`. You can also pass filter/sort params on the search page by using the `$orderData` or `$params` as normal e.g. if you want to paginate the search results.

#### Listing Helper

A couple of functions have been added to the ProductsHelper to fetch the information for displaying product prices. It is beneficial to use these instead of accessing the array directly as it makes it more extendable and future proof incase the arrays change.

You can find the full set of methods in the ProductsHelper but here is an example of using them:

	<?php if ($this->Products->isSalePrice($product)): ?>
		<span class="price sale">
			<?= $this->Products->getPrice($product); ?>
		</span>
		<span class="price">
			<?= $this->Products->getSalePrice($product, true); ?>
		</span>
	<?php else: ?>
		<span class="price">
			<?= $this->Products->getPrice($product); ?>
		</span>
	<?php endif; ?>

#### Getting Stock on the Listing Page

By default inventory isn't pulled out on the listing page but can be done with the following:

Override the ProductsComponent and the `_addAdditionalParamsToListing` method

	<?php

	App::uses('ProductsComponent', 'EvShop.Controller/Component');

	class EvShopProductsComponent extends ProductsComponent {

		/**
		 * Check if specific ordering data is provided and if so call the function that adds the correct parameters to the
		 * query. Extend to add add your own parameters to the listing query.
		 * @param array $currentParams The current parameters of the query to change. Normally the defaults set in listing()
		 * @param array $orderData     The ordering data (direction and currencyId if it is set)
		 * @param Model $queryModel    The model that is being queried on, listing uses Product
		 */
		protected function _addAdditionalParamsToListing(&$queryModel, $currentParams, $orderData) {
			parent::_addAdditionalParamsToListing($queryModel, $currentParams, $orderData);
			$queryModel->Variant->linkInventory();
			$currentParams['contain']['Variant']['Inventory'] = [];
			return $currentParams;
		}
	}

Add this method to your override ProductsHelper

	/**
	 * Used for the listing page, checks if a variant is in stock
	 * @param  $variants Variants passed from product listing
	 * @return boolean   Returns true if in stock
	 */
		public function inStock($variants) {
			$soldOutVariants = 0;
			$variantCount = 0;

			// Loop through each variant and set the price and saleprice
			foreach ($variants as $key => $Variant) {

				// Due to an after find the is elements in that are not variants
				if (!is_int($key)) {
					continue;
				}

				$variantCount++;

				// If the variant is not purchasable then set it to sold out
				if (isset($Variant['Inventory']) && empty($Variant['Inventory'])) {
					$soldOutVariants++;
				} else {

					//oos_action is stored as json string so needs to be decoded before being tested upon
					if (isset($Variant['Inventory']['oos_action']) && !is_array($Variant['Inventory']['oos_action'])) {
						$Variant['Inventory']['oos_action'] = json_decode($Variant['Inventory']['oos_action']);
					}

					if (!$this->Inventory->allowPurchase($Variant)) {
						$soldOutVariants++;
					}
				}

			}

			// Check if the amount of sold out variants is the same as the amount of variants
			if ($soldOutVariants != $variantCount) {
				return true;
			}

			return false;
		}

Then you can do

	<?php if (!$this->Products->inStock($variants)): ?>


### Category Controllers

In most shops, it's likely that it's the categories listing that is the main bit which will be modified. Some "stub" methods are defined within the categories controller which are used to pass array parameters to the find methods when on category / product listings as shown below.

	$this->set(
		array(
			'categoryListing' => $this->Categories->listingByParent(
				$id,
				$this->_processCategoryParams($data),
				false
			),
			'productListing' => $this->Products->listingByCategory(
				$this->categoryIds,
				$this->_processProductParams($data)
			)
		)
	);

This was used with great effect in Brighton Tools project to customise the category listing to also include a brand filter and to also amend the default ordering of products.

	protected function _processProductParams($Category) {
		$params = parent::_processProductParams($Category);

		if (! empty($this->request->params['named']['brand_id'])) {
			$params['conditions']['Product.brand_id'] = $this->request->params['named']['brand_id'];
		}

		$params['maxLimit'] = 1000000;

		$params['order'] = 'Product.created DESC, CategoriesProduct.sequence ASC, Product.name ASC';

		return $params;
	}

### Google Feed

Bundled with the plugin is a Google Feed Controller that is used to create a Google Xml product feed. This is automatically accessible via http://thesite.com/google-product-feed.xml

Unless there are specific requirements, the included setup should cover most cases where you require the feed, the only thing that needs to be done during setup is to set the Google Category for the products within the Config. The google categories can be found at <https://support.google.com/merchants/answer/1705911>. This will currently set the same Google category for each product. The internal Shop categories are set to the product at the `product_type` element where it will select the first category it returns (if multiple are selected).

##Rebuilding foreign currencies
The shop supports automatically updating foreign prices. To do this you just need to make sure the autoManageCurrencies variable is set to true in your config (this has been intentionally left as a config variable instead of a site setting as it's highly unlikely that we want clients to be messing with this setting).

When this is enabled, on your variants, only pricing for your default currency will be shown. All other currencies will be automatically updated when you save the record.

###Updating via command line
A command line option is also provided to allow you to automatically update all product pricing in one go. This is generally useful if you want to update all foreign prices nightly so they match up with an up to date copy of the exchange rates.

To use the command line script, simply run:

    ./app/Console/cake EvShop.UpdatePricing update

It's recommended that you update your currency exchange rates first. Instructions for the shell script that handles that can be found in the EvCurrency addon's readme file.


## Events

### EvShop.Model.Product.saved

Called in Products afterSave callback once variants have processed.

#### Parameters

* `newItem` - contains the boolean value from afterSaves created parameter.


### EvShop.Model.Variant.saved

Called in Variant afterSave callback.

#### Parameters

* `newItem` - contains the boolean value from afterSaves created parameter.
