<?php
	$this->extend('/Scaffolds/admin_form');

	echo $this->element('Forms/fields', array('fields' => $fields));

	$this->append('additionalFormTabs');

	// Add in Variant Pricing tab when we have a singular variant
	if (isset($this->request->data['Variant']) && count($this->request->data['Variant']) == 1) {
		$tabContent = $this->element('EvShop.Variants/manage',
			array(
				'fields' => $variantFields,
				'productTab' => true
			)
		);
	} elseif (isset($this->request->data['Variant']) && count($this->request->data['Variant']) > 1) {
		$tabContent = 'If you wish to edit the pricing for this item, please ';
		$tabContent .= $this->Html->link(
			'click here',
			$toolbar['Edit Variants']['url'],
			array(
				'target' => '_blank'
			)
		);
		$tabContent .= '.';
	} else {
		$tabContent = 'You must create the product before you can manage its pricing';
	}

	echo $this->Element(
		'form_tab',
		array(
			'title' => __('Pricing'),
			'tabContent' => $tabContent,
			'divOptions' => array(
				'class' => 'field-data'
			)
		)
	);

	echo $this->Html->script(
		array(
			'EvShop.variantImage',
		),
		array('inline'=>false)
	);

	// Handle image slots.
	if (isset($variantImageSlots) && is_array($variantImageSlots)):

	    // We have multiple image sections on a page.

	    foreach ($variantImageSlots as $variantImageSection => $currentVariantImageSlots):
	        echo $this->element(
	            'form_tab',
	            array(
	                'title' => __('Images - %s', $this->InflectorExt->camelToHumanize($variantImageSection)),
	                'tabContent' => $this->element(
	                    'EvShop.VariantImages/image_fields',
	                    array(
	                        'imageSection' => $variantImageSection,
	                        'imageSlots' => $currentVariantImageSlots,
	                        'options' => $chosenOptions
	                    )
	                ),
	                'divOptions' => array(
	                    'class' => 'img-tab'
	                )
	            )
	        );

	    endforeach;

	elseif (isset($variantImageSlots) && $variantImageSlots !== 0):

	    echo $this->element(
	        'form_tab',
	        array(
	            'title' =>  __('Images'),
	            'tabContent' => $this->element(
	                'EvShop.VariantImages/image_fields',
	                array(
	                    'imageSection' => 'main',
	                    'options' => $chosenOptions
	                )
	            ),
	            'divOptions' => array(
	                'class' => 'img-tab'
	            )
	        )
	    );
	endif;

	$this->end();


	if ($actionLabel === 'Edit'): ?>
		<div class="form-group">
			<div class="col-xs-12 col-md-9 col-md-offset-3 col-lg-10 col-lg-offset-2 col-xs-offset-3">
				<div class="checkbox">
					<input type="hidden" name="pricing" id="_pricing" value="0" />
					<label for="pricing" class="col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label"><input type="checkbox" name="pricing" null="1" length="1" value="1" id="pricing" class="form-control" /> <?php echo __('Modify pricing after saving'); ?></label>
				</div>
			</div>
		</div>
	<?php endif;
