<div class="row">
	<div class="col-xs-12">
		<div class="well well-sm">
			<button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#bulkUpdateModal">
				Bulk-Update Pricing
			</button>
		</div>
	</div>
</div>

<div class="modal fade" id="bulkUpdateModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	<div class="modal-dialog" role="document">
	    <div class="modal-content bs">
	      	<div class="modal-header">
	        	<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>	</button>
	        	<h4 class="modal-title" id="myModalLabel">Bulk Update Variants</h4>
	      	</div>

	        <form class="form-horizontal">
		      	<div class="modal-body">
		      		<div class="modal-loading" style="display:none;">
		      			<div class="row">
		      				<div class="col-xs-12 text-center">
		      					<i class="fa fa-cog fa-spin fa-5x"></i>
		      					<h1>Please Wait...</h1>
		      				</div>
		      			</div>
		      		</div>
					<div class="panel-group" id="accordion" role="tablist" aria-mtiselectable="true">
						<div class="panel panel-default">
							<div class="panel-heading" role="tab" id="pricingHeader">
								<h4 class="panel-title">
									<a href="#collapsePricing" role="button" data-toggle="collapse" data-parent="#accordion" aria-expanded="true" aria-controls-"collapsePricing">
										Update Pricing
									</a>
								</h4>
							</div>
							<div id="collapsePricing" class="panel-collapse collapse in" role="tabpanel" area-labelledby="pricingHeader">
								<div class="panel-body">
									<?php foreach ($currencies as $currencyId => $currencyName): ?>
										<?php
										if (Configure::read('EvShop.autoManageCurrencies') == true && isset($defaultCurrency) && $currencyId != $defaultCurrency):
											continue;
										endif;
										?>
										<fieldset class="collapsable-fieldset collapsable-fieldset--inline">
											<legend>Currency: <?php echo $currencyName; ?></legend>
											<div>
												<?php
													$priceId = null;
													if (isset($Variant['VariantPricing'][$currencyId]['id'])):
														$priceId = $Variant['VariantPricing'][$currencyId]['id'];
													endif;
													echo $this->Form->addField(
														'BulkVariants.VariantPricing.' . $currencyId . '.id',
														array(
															'type' => 'hidden',
															'value' => $priceId
														)
													);

													echo $this->Form->addField(
														'BulkVariants.VariantPricing.' . $currencyId . '.currency_id',
														array(
															'type' => 'hidden',
															'value' => $currencyId
														)
													);
												?>

												<?php
													//Get the tax rate for the current product
													$variants = $this->request->data['Variant'];

													$taxRate = 0;
													if (!empty($variants)) {
														if (isset($variants[0]['Product']['TaxLevel']['rate'])) {
															$taxRate = $variants[0]['Product']['TaxLevel']['rate'];
														}
													}
												?>

												<div class="col-xs-12">
													<?php
														$rrp = '';
														if (isset($Variant['VariantPricing'][$currencyId]['rrp'])):
															$rrp = $this->Number->precision($Variant['VariantPricing'][$currencyId]['rrp'], 2);
														endif;
														echo $this->Form->addField(
															'BulkVariants.VariantPricing.' . $currencyId . '.rrp',
															array(
																'type' => 'input',
																'label' => 'RRP ex. VAT',
																'value' => $rrp,
																'data-type' => 'currency',
																'data-field' => 'rrp',
																'data-currency' => $currencyId,
																'data-taxrate' => ($taxRate > 0) ? $taxRate : null,
																'div' => 'form-group col-xs-6'
															)
														);
													?>

													<div class="col-xs-12 col-sm-6 col-md-6">
														<button type="button" class="btn btn-danger variant-modal-remove-price">Remove Price</button>
													</div>
												</div>

												<div class="col-xs-12">
													<?php
														$price = '';
														if (isset($Variant['VariantPricing'][$currencyId]['price'])):
															$price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['price'], 2);
														endif;
														echo $this->Form->addField(
															'BulkVariants.VariantPricing.' . $currencyId . '.price',
															array(
																'type' => 'input',
																'label' => 'Price ex. VAT',
																'value' => $price,
																'data-type' => 'currency',
																'data-field' => 'price',
																'data-currency' => $currencyId,
																'data-taxrate' => ($taxRate > 0) ? $taxRate : null,
																'div' => 'form-group col-xs-6',
															)
														);
													?>

													<div class="col-xs-12 col-sm-6 col-md-6">
														<button type="button" class="btn btn-danger variant-modal-remove-price">Remove Price</button>
													</div>
												</div>

												<div class="col-xs-12">
													<?php
														$sale_price = '';
														if (isset($Variant['VariantPricing'][$currencyId]['sale_price'])):
															$sale_price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['sale_price'], 2);
														endif;

														echo $this->Form->addField(
															'BulkVariants.VariantPricing.' . $currencyId . '.sale_price',
															array(
																'type' => 'input',
																'label' => 'Sale Price ex. VAT',
																'value' => $sale_price,
																'data-type' => 'currency',
																'data-field' => 'sale_price',
																'data-currency' => $currencyId,
																'data-taxrate' => ($taxRate > 0) ? $taxRate : null,
																'div' => 'form-group col-xs-6',
															)
														);
													?>

													<div class="col-xs-12 col-sm-6 col-md-6">
														<button type="button" class="btn btn-danger variant-modal-remove-price">Remove Price</button>
													</div>
												</div>

												<div class="col-xs-12">
													<?php
														$trade_price = '';
														if (isset($Variant['VariantPricing'][$currencyId]['trade_price'])):
															$trade_price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['trade_price'], 2);
														endif;

														echo $this->Form->addField(
															'BulkVariants.VariantPricing.' . $currencyId . '.trade_price',
															array(
																'type' => 'input',
																'value' => $trade_price,
																'label' => 'Trade Price',
																'data-type' => 'currency',
																'data-field' => 'trade_price',
																'data-currency' => $currencyId,
																'div' => 'form-group col-xs-6'
															)
														);
													?>

													<div class="col-xs-12 col-sm-6 col-md-6">
														<button type="button" class="btn btn-danger variant-modal-remove-price">Remove Price</button>
													</div>

													<div class="col-xs-12 col-sm-6 col-md-6">
														<p>
															Tax will not be applied to trade orders.
														</p>
													</div>
												</div>
											</div>
										</fieldset>
									<?php endforeach; ?>
								</div>
							</div>
						</div>

						<div class="panel panel-default">
							<div class="panel-heading" role="tab" id="optionsHeader">
								<h4 class="panel-title">
									<a href="#collapseOptions" role="button" data-toggle="collapse" data-parent="#accordion" aria-expanded="false" aria-controls-"optionsHeader">
										Options
									</a>
								</h4>
							</div>
							<div id="collapseOptions" class="panel-collapse collapse" role="tabpanel" area-labelledby="optionsHeader">
								<div class="panel-body">
									<p>You can restrict this change to only apply to products that match a specific criteria by selecting as many product variant options from below. The counter at he bottom of this form will automatically update to let you know how many product variants will be affected by this change.</p>
									<div class="row">
										<?php foreach ($optionGroups as $optionGroup): ?>
											<div class="col-xs-12">
												<fieldset class="collapsable-fieldset collapsable-fieldset--inline" data-option-group="<?=$optionGroup['OptionGroup']['name'];?>">
													<legend><?php echo $optionGroup['OptionGroup']['name']; ?></legend>
													<div>
														<?php foreach ($optionGroup['Option'] as $option): ?>
															<?php
																echo $this->Form->addField(
																	'BulkVariants.Options.' . $option['id'],
																	array(
																		'type' => 'boolean',
																		'value' => 1,
																		'label' =>  [
																			'text' => $option['name']
																		],
																		'div' => 'form-group col-xs-12 col-sm-6 col-md-3',
																		'class' => 'variant-option-selector',
																		'data-option' => $option['id']
																	)
																);
															?>
														<?php endforeach; ?>
													</div>
												</fieldset>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
		      	</div>
		      	<div class="modal-footer">
		      		<span class="pull-left modal-footer-text indented">
		      			<strong>Applicable Product Variants:</strong> <span class="totalApplicableVariants">0</span>
		      		</span>
		        	<button type="button" class="btn btn-default" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
		        	<button type="button" class="btn btn-primary variant-modal-save"><i class="fa fa-check"></i> Save changes</button>
		    	</div>
			</form>
	    </div>
	</div>
</div>
