<div class='input file file--image js--file container-fluid'>
	<?php
		$modelAlias = 'VariantImage';
		echo $this->Form->input($prefix.$modelAlias.'.'.$key.'.model', array('type' => 'hidden', 'value' => $model));
		echo $this->Form->input($prefix.$modelAlias.'.'.$key.'.attachment_type', array('type' => 'hidden', 'value' => $type));
		echo $this->Form->input($prefix.$modelAlias.'.'.$key.'.id', array('type' => 'hidden'));
	?>

	<div class='preview row' <?php if(isset($images[$key]) && $images[$key]){ echo "data-id='{$images[$key]['id']}' data-sequence='{$images[$key]['sequence']}' ";} ?> data-filetype='images'>
		<div class="preview__info cols-xs-3">
			<?php if(isset($images[$key]) && $images[$key]): ?>

				<h4 class='preview__title'> <?php echo __('Image details'); ?> </h4>;
				<b>Name</b> <?php echo $images[$key]['filename']; ?> <br />
				<b>Size</b> <?php echo $images[$key]['size']; ?> <br />
				<b>Type</b> <?php echo strtoupper($images[$key]['type']); ?> <br />
				<?php echo $this->Html->link(__('View current image'), DS . $images[$key]['filepath'], array('target' => '_blank')); ?>

			<?php else: ?>
				<?php echo $this->Img->resize('./upload-file-placeholder.png', array('width' => 250, 'height' => 200)); ?>

			<?php endif; ?>
		</div>
		<div class="preview__tools col-xs-5">
			<?php
				$imageFields = array('caption', 'alt', 'link_text', 'link_url');

				foreach ($imageFields as $imageField):

						if ($fields===true || (is_array($fields) && (in_array($imageField, $fields) || array_key_exists($imageField, $fields))) ) {

							$default = array(
								'type' => 'string',
								'label' => false,
								'div' => array('class' => 'input preview__tools__input col-xs-12')
							);

							//if(array_key_exists($imageField, $fields) && is_array($fields[$imageField])) {
							if (isset($fields[$imageField]) && is_array($fields[$imageField])) {
								$fieldSettings = array_merge($default, $fields[$imageField]);
							} else {
								$fieldSettings = $default;
							}
							//pr($fieldSettings);
							$labelText = $fieldSettings['label'] ? $fieldSettings['label'] : Inflector::humanize($imageField);
							$fieldSettings['label'] = $labelText;
							echo $this->Form->input($prefix.$modelAlias.".".$key.".".$imageField, $fieldSettings);
						}
				endforeach;

				echo $this->Form->input($prefix.$modelAlias.'.'.$key.".filename",
					array(
						'label' => "Replacement Image (optional)",
						'type' => 'file',
						'class' => 'image_upload',
						'div' => array('class' => 'input preview__tools__input')
					)
				);

				if (isset($options) && !empty($options)) {
					echo $this->Form->radio($prefix.$modelAlias.'.'.$key.'.is_restricted',
						[
							'Generic',
							'Restricted'
						],
						[
							'legend' => [
								'text' => 'Image Restriction: <span>(Generic to display on all variants, restricted to display on chosen)</span>',
								'class' => 'col-xs-12',
							],
							'class' => 'input-radio-image-restriction',
							'wrapInput' => [
								'tag' => 'div',
								'class' => 'radio col-xs-6'
							],
						]
					);
				}
			?>

			<?php if (isset($options) && !empty($options)): ?>
				<div class="preview__variant-image-options col-xs-12">
					<?php
						$optionGroupCount = 0;

						$imageOptions = [];
						$image = $images[$key];
						if (!empty($image['VariantImageOption'])) {
							$imageOptions = $image['VariantImageOption'];
						}

						foreach ($options as $optionGroupName => $optionGroupData) {
							$optionGroupId = $optionGroupData['option_group_id'];
							unset($optionGroupData['option_group_id']);

							echo $this->Form->addField(
								$prefix.$modelAlias.'.'.$key.'.'.'VariantImageOption.' . $optionGroupCount . '.option_group_id',
								[
									'type' => 'hidden',
									'value' => $optionGroupId
								]
							);

							//Work out which options are selected
							$selectedOptions = [];
							foreach ($imageOptions as $option) {
								if ($option['option_group_id'] == $optionGroupId) {
									$selectedOptions[] = $option['option_id'];
								}
							}

							echo $this->Form->addField(
								$prefix.$modelAlias.'.'.$key.'.'.'VariantImageOption.' . $optionGroupCount . '.options',
								[
									'type' => 'chosen_multiselect',
									'options' => $optionGroupData,
									'class' => 'chosen-select',
									'label' => $optionGroupName,
									'selected' => $selectedOptions
								]
							);

							$optionGroupCount++;
						}
					?>
				</div>
			<?php endif; ?>
		</div>

		<?php if(!isset($reorder) || $reorder): ?>
			<label class="reorder col-xs-2">
				&nbsp;
			</label>
		<?php endif; ?>

		<div class="preview__tools__delete col-xs-2">
			<?php
				if (isset($images[$key]) && $images[$key]) {
					$url = $this->Html->url(array('controller' => 'images', 'action'=>'remove', $images[$key]['id'], 'ajax' => true, 'plugin' => false));
				} else {
					$url = '#';
				}

				echo '<a href="' . $url . '" class="delete-image btn btn-sm btn-danger">';
					echo '<i class="fa fa-times"></i>';
					echo ' Delete Image';
				echo '</a>';
			 ?>
		</div>
	</div>
</div>
