<?php $optionGroups = $this->Products->getOptionGroups($data); ?>
<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>SKU</th>

            <?php foreach ($optionGroups as $groupName): ?>
                <td class="volt"><?=$groupName?></td>
            <?php endforeach; ?>

            <th>Price</th>
            <th>Price (inc. Tax)</th>
            <?php
            // Only load in trade pricing if the trade session exists.
            if (CakeSession::read('EvShop.isTrade') && Configure::read('SiteSetting.ev_shop.enable_trade_pricing') == '1'):
                echo '<th>Trade Price</th>';

                if (Configure::read('SiteSetting.ev_shop.disable_tax_on_trade_pricing') != '1'):
                    echo '<th>Trade Price (inc. Tax)</th>';
                endif;
            endif;
            ?>
            <th> </th>
            <th> </th>
            <th> </th>
        </tr>
    </thead>

    <?php
        $tableCells = array();
        foreach ($data['Variant'] as $key => $Variant):

            $tableCells[$key][] = $Variant['sku'];

            foreach ($optionGroups as $groupId => $groupName):
                $tableCells[$key][] = $this->Products->getOption($Variant, $groupId);
            endforeach;

            $currencyId = CakeSession::read('EvCurrency.currencyId');

            $tableCells[$key][] = $this->Number->currency(
                $Variant['VariantPricing'][$currencyId]['rrp_incTax'],
                $currencies[$currencyId]
            );
            $tableCells[$key][] = $this->Number->currency(
                $Variant['VariantPricing'][$currencyId]['price_incTax'],
                $currencies[$currencyId]
            );

            // Only load in trade pricing if the trade session exists.
            if (CakeSession::read('EvShop.isTrade') && Configure::read('SiteSetting.ev_shop.enable_trade_pricing') == '1'):
                $tableCells[$key][] = $this->Number->currency(
                    $Variant['VariantPricing'][$currencyId]['trade_price'], $data,
                    $currencies[$currencyId]
                );
                if (Configure::read('SiteSetting.ev_shop.disable_tax_on_trade_pricing') != '1'):
                    $tableCells[$key][] = $this->Number->currency(
                        $Variant['VariantPricing'][$currencyId]['trade_price_incTax'], $data,
                        $currencies[$currencyId]
                    );
                endif;
            endif;

            if ($this->Inventory->allowPurchase($Variant)):
                $tableCells[$key][] = 'Add Form';
            else:
                $tableCells[$key][] = $this->Inventory->oosMessage();
            endif;


            if ($this->Inventory->showDelayedMessage($Variant)):
                $tableCells[$key][] = $this->Inventory->delayedMessage();
            else:
                $tableCells[$key][] = '';
            endif;


            if ($this->Inventory->showLowStockMessage($Variant)):
                 $tableCells[$key][] = $this->Inventory->lowStockMessage();
            else:
                $tableCells[$key][] = '';
            endif;

        endforeach;

        echo $this->Html->tableCells($tableCells);
    ?>
</table>
