<?php
/**
 * VariantFixture
 *
 */
class VariantFixture extends CakeTestFixture {

	public $table = 'ev_shop_variants';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'product_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
		'sku' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
		'rrp' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'sale_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 5, 'unsigned' => false),
		'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_variants_products1_idx' => array('column' => 'product_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'product_id' => 1,
			'name' => 'Red Matte',
			'sku' => 'Lorem ipsum dolor sit amet',
			'rrp' => '',
			'price' => '',
			'sale_price' => '',
			'sequence' => 2,
			'is_active' => 1,
			'created' => '2015-07-09 14:25:34',
			'modified' => '2015-07-09 14:25:34'
		),
		array(
			'id' => 2,
			'product_id' => 1,
			'name' => 'Blue Matte',
			'sku' => 'Lorem ipsum dolor sit amet',
			'rrp' => '',
			'price' => '',
			'sale_price' => '',
			'sequence' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:25:34',
			'modified' => '2015-07-09 14:25:34'
		),
		array(
			'id' => 3,
			'product_id' => 2,
			'name' => 'My Product 2',
			'sku' => 'qweqweqwe',
			'rrp' => '',
			'price' => '',
			'sale_price' => '',
			'sequence' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:25:34',
			'modified' => '2015-07-09 14:25:34'
		),
		array(
			'id' => 4,
			'product_id' => 3,
			'name' => 'My in-active product 3',
			'sku' => 'asdasdasd',
			'rrp' => '',
			'price' => '',
			'sale_price' => '',
			'sequence' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:25:34',
			'modified' => '2015-07-09 14:25:34'
		)
	);

}
