<?php
App::uses('EvShopAppModel', 'EvShop.Model');
/**
 * Option Model
 *
 * @property OptionGroup $OptionGroup
 * @property Variant $Variant
 */
class Option extends EvShopAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'An option name must be entered'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'OptionGroup' => array(
			'className' => 'EvShop.OptionGroup'
		)
	);

/**
 * hasAndBelongsToMany associations
 *
 * @var array
 */
	public $hasAndBelongsToMany = array(
		'Variant' => array(
			'className' => 'EvShop.Variant',
			'joinTable' => 'ev_shop_options_variants'
		)
	);

	/**
	 * get the given options name data
	 *
	 * @param 	array 	array of option IDs
	 * @return 	array 	array list of all options in id => name format
	 */
	public function getOptionNames($options) {
		return $this->find(
			'list',
			array(
				'conditions' => array(
					'Option.id' => $options
				),
				'callbacks' => false
			)
		);
	}
}
