<?php
App::uses('EvShopAppModel', 'EvShop.Model');
/**
 * Brand Model
 *
 * @property Product $Product
 */
class Brand extends EvShopAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'config' => 'EvShop',
			'alias' => 'brand/:displayField/*'
		),
		'MetaData.Meta',
		'EvTemplates.Template' => array(
			'formInject' => true,
			'restrictTo' => 'Brand'
		)
	);

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'name';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'A brand name must be entered.'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

	/**
	 * hasMany associations
	 *
	 * @var array
	 */
	public $hasMany = array(
		'Product' => array(
			'className' => 'EvShop.Product'
		)
	);

	public $imageSlots = array(
		'logo' => array(
			'slots' => 1,
			'fields' => false
		)
	);
}
