<?php

App::uses('CakeEventListener', 'Event');
App::uses('DiscountLib', 'EvDiscount.Lib');

class EvShopUpdateLowestPriceOnTaxChangeListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvShop.Model.Product.saved' => 'updateLowestPriceOnTaxChange',
		);
	}

/**
 * Update the lowest price of each variant when a product is saved. Checks if the EvTax plugin is loaded
 * as it is the only field on a product that may effect variant prices.
 */
	public function updateLowestPriceOnTaxChange(CakeEvent $Event) {
		if (!$Event->data['created']) {
			//Only want to update lowest price if the product has been updated as prices won't exist otherwise
			if (CakePlugin::loaded('EvTax')) {
				//Only want to update if EvTax is loaded because the tax level is the only thing that will effect the variant prices.
				$VariantPricing = EvClassRegistry::init('EvShop.VariantPricing');
				$productsPricings = $VariantPricing->find(
					'all',
					[
						'joins' => [
							[
								'table' => 'ev_shop_variants',
								'alias' => 'Variant',
								'conditions' => [
									'Variant.id = VariantPricing.variant_id'
								]
							],
						],
						'conditions' => [
							'Variant.product_id' => $Event->data['product']['id']
						],
					]
				);

				$productsPricings = Hash::extract($productsPricings, '{n}.{n}.VariantPricing');

				foreach ($productsPricings as $pricingKey => $pricingRecord) {
					//updateLowestPrice expects a single record under 'VariantPricing'
					$productsPricings[$pricingKey] = $VariantPricing->updateLowestPrice(['VariantPricing' => $pricingRecord])['VariantPricing'];
				}
				return $VariantPricing->saveAll($productsPricings, array('deep' => false, 'callbacks' => false));
			}
		}
	}
}
