<?php

App::uses('CakeEventListener', 'Event');
App::uses('DiscountLib', 'EvDiscount.Lib');

class EvShopCheckForDiscountRestrictionsListener implements CakeEventListener {



	public function implementedEvents() {
		return array(
			'EvBasket.Component.Basket.CheckDiscountRestrictions' => 'checkForDiscountRestrictions',
		);
	}

	/**
	 * rebuild discount due to basket amends
	 *
	 * @param 	CakeEvent
	 */
	public function checkForDiscountRestrictions(CakeEvent $Event) {
		$result = array();

		if (isset($Event->data['discount']['CodeRestriction'])
			&& ! empty($Event->data['discount']['CodeRestriction'])
			&& isset($Event->data['basket'])
			&& ! empty($Event->data['basket'])) {

			// Restrictions were found. Check to see if they are for the shop
			$basket = $Event->data['basket'];
			$discount = $Event->data['discount'];

			// Split out basket items into an array of product ids
			$productIds = array();

			foreach ($basket['BasketItem'] as $basketItemKey => $basketItem) {

				if ($basketItem['model'] == 'EvShop.Variant') {
					if (isset($basketItem['Variant']['Product'])) {
						$productIds[$basketItemKey] = $basketItem['Variant']['Product']['id'];
					}
				} elseif ($basketItem['model'] == 'EvShop.Product') {
					$productIds[$basketItemKey] = $basketItem['model_id'];
				}
			}


			// We've now got a list of product ids in the basket. Now we need to go through each code restriction
			// and work out if it applies to any of the products in the basket.
			foreach ($discount['CodeRestriction'] as $restriction) {
				if ($restriction['model'] == 'EvShop.Product') {

					// Loop through the basket items to find a product
					foreach ($productIds as $basketItemKey => $productId) {

						if ($productId === $restriction['model_id']) {
							// It's a match - now we need the item basket item price.
							$price = $basket['BasketItem'][$basketItemKey]['unit_price'];

							// Work out the discount
							$result[] = array(
								'model' => $basket['BasketItem'][$basketItemKey]['model'],
								'model_id' => $basket['BasketItem'][$basketItemKey]['model_id'],
								'quantity' => $basket['BasketItem'][$basketItemKey]['quantity'],
								'unitPrice' => $price - DiscountLib::calculate($discount, $price),
								'taxRate' => $basket['BasketItem'][$basketItemKey]['tax_rate']
							);
						}
					}
				} elseif ($restriction['model'] == 'EvShop.Brands') {
					// Check if the brand applies to any of the products
					foreach ($productIds as $basketItemKey => $productId) {
						foreach ($basket['BasketItem'] as $basketItemKey => $basketItem) {
							if (isset($basketItem['Variant']['Product']['brand_id'])
								&& $basketItem['Variant']['Product']['brand_id'] > 0) {

								if ($basketItem['Variant']['Product']['brand_id'] == $restriction['model_id']) {

									$price = $basketItem['unit_price'];

									// Work out the discount
									$result[] = array(
										'model' => $basket['BasketItem'][$basketItemKey]['model'],
										'model_id' => $basket['BasketItem'][$basketItemKey]['model_id'],
										'quantity' => $basket['BasketItem'][$basketItemKey]['quantity'],
										'unitPrice' => $price - DiscountLib::calculate($discount, $price),
										'taxRate' => $basket['BasketItem'][$basketItemKey]['tax_rate']
									);
								}

							} elseif (isset($basket['BasketItem']['Product']['brand_id']) && $basket['BasketItem']['Product']['brand_id']) {

								if ($basket['BasketItem']['Product']['brand_id'] == $restriction['model_id']) {

									$price = $basket['BasketItem'][$basketItemKey]['unit_price'];

									// Work out the discount
									$result[] = array(
										'model' => $basket['BasketItem'][$basketItemKey]['model'],
										'model_id' => $basket['BasketItem'][$basketItemKey]['model_id'],
										'quantity' => $basket['BasketItem'][$basketItemKey]['quantity'],
										'unitPrice' => $price - DiscountLib::calculate($discount, $price),
										'taxRate' => $basket['BasketItem'][$basketItemKey]['tax_rate']
									);
								}
							}
						}
					}
				} elseif ($restriction['model'] == 'EvShop.Categories') {

					foreach ($productIds as $basketItemKey => $productId) {

						// Load the category records associated with this product id
						$categoryProductModel = EvClassRegistry::init('EvShopCategoriesProducts');
						$categoryProducts = $categoryProductModel->find('list', array(
							'fields' => array('category_id'),
							'conditions' => array(
								'product_id' => $productId
							)
						));

						if (in_array($restriction['model_id'], $categoryProducts)) {

							$price = $basket['BasketItem'][$basketItemKey]['unit_price'];
							$updatedItem = $basket['BasketItem'][$basketItemKey];

							$result[] = array(
								'model' => $basket['BasketItem'][$basketItemKey]['model'],
								'model_id' => $basket['BasketItem'][$basketItemKey]['model_id'],
								'quantity' => $basket['BasketItem'][$basketItemKey]['quantity'],
								'unitPrice' => $price - DiscountLib::calculate($discount, $price),
								'taxRate' => $basket['BasketItem'][$basketItemKey]['tax_rate']
							);
						}
					}
				}
			}
			return $result;
		}
		return array();
	}
}
