<?php
App::uses('EvShopAppController', 'EvShop.Controller');
App::uses('InflectorExt', 'EvInflector.Lib');

class VariantsController extends EvShopAppController {

	public function beforeFilter() {
		$this->adminActions[] = 'admin_manage';
		unset($this->adminActions[array_search('admin_edit', $this->adminActions)]);
		unset($this->adminActions[array_search('admin_delete', $this->adminActions)]);
		parent::beforeFilter();
	}

	protected function _adminManageToolbar($id) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$actions = array(
			'All Products' => array(
				'url' => array(
					'controller' => 'products',
					'action' => 'index'
				),
				'class' => 'toolbar__btn--listing'
			),
			'Edit Product' => array(
				'url' => array(
					'controller' => 'products',
					'action' => 'edit',
					$id
				),
				'class' => 'toolbar__btn--edit'
			)
		);

		return $actions;
	}

	/**
	 * just incase redirect to products index
	 */
	public function admin_index() {
		$this->redirect(
			array(
				'controller' => 'products'
			)
		);
	}

	/**
	 * display the variants management
	 * styled as just pricing rather then variants to prevent confusion
	 *
	 * @param 	int 	product id
	 */
	public function admin_manage($id) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		if ($this->request->is('post') || $this->request->is('put')) {

			if ($Model->saveMany($this->request->data['Variant'], array('deep' => true))) {

				// save was successful
				$this->Flash->success(
					array(
						'title' => 'Save Successful',
						'description' => 'Pricing data has been saved successfully'
					)
				);

				// check whether to redirect to product listing or pricing page again
				if (isset($this->request->data['return']) && $this->request->data['return'] == 1) {

					$this->Session->write("Admin.$modelAlias.return", true);
					$return = array(
						'action' => 'manage',
						$id
					);
				} else {

					$this->Session->delete("Admin.$modelAlias.return");

					$redirect = $this->Session->read("Admin.$modelAlias.filter");
					if (strpos($redirect, 'Filter') !== false) {
						$return = $redirect;
					} else {
						if (in_array('EvShopProducts', App::objects('Controller'))) {
							$return = array(
								'plugin' => false,
								'controller' => 'ev_shop_proucts',
							);
						} else {
							$return = array(
								'plugin' => 'ev_shop',
								'controller' => 'products'
							);
						}
						$return['action'] = 'index';
					}
				}

				$this->redirect($return);

			} else {
				// uh oh, fail.
				$this->Flash->fail(
					array(
						'title' => 'Save Failed',
						'description' => 'There was a problem saving the pricing. Please check that you have correctly entered valid prices in each currency field. (e.g 20.00 and not just 20).'
					)
				);
			}

		}

		$this->request->data['Variant'] = $Model->readForManage($id);

		if (CakePlugin::loaded('EvCurrency')) {
			$this->Currencies->injectAdminForm(array(), $Model, $id);

			$Currencies = EvClassRegistry::init('EvCurrency.Currency');
			$defaultCurrency = $Currencies->find('first', array(
				'conditions' => array(
					'is_default' => '1'
				)
			));

			if (! empty($defaultCurrency)) {
				$this->set('defaultCurrency', $defaultCurrency['Currency']['id']);
			}
		}

		$OptionGroupsModel = EvClassRegistry::init('EvShop.OptionGroup');
		$optionIds = Hash::extract($this->request->data['Variant'], '{n}.Option.{n}.id');

		$optionGroups = $OptionGroupsModel->find('all', array(
			'contain' => array(
				'Option' => [
					'conditions' => [
						'Option.id' => $optionIds
					]
				]
			)
		));

		foreach ($optionGroups as $groupIndex => $group) {
			if (!count($group['Option']) > 0) {
				//Remove groups that don't contain any options
				unset($optionGroups[$groupIndex]);
			}
		}

		$this->set('optionGroups', $optionGroups);

		$actionLabel = 'Manage';
		$this->set(
			array(
				'actionLabel' => $actionLabel,
				'title_for_layout' => $actionLabel . ' ' . InflectorExt::humanize($Model->displayName),
				'toolbar' => $this->_adminManageToolbar($id),
				'fields' => $this->_adminVariantManageFields()
			)
		);

		$this->view = 'EvShop./Variants/admin_manage';
	}
}
