<?php
App::uses('AppController', 'Controller');

class EvShopAppController extends AppController {

	/**
	 * Constructor
	 *
	 * @param ComponentCollection $collection A ComponentCollection this component can use to lazy load its components
	 * @param array $settings Array of configuration settings.
	 */
	public function __construct($request = null, $response = null) {
		$this->components[] = 'EvShop.Products';
		$this->components[] = 'EvShop.Categories';
		$this->components[] = 'EvShop.Brands';

		if (CakePlugin::loaded('EvBreadcrumb')) {
			$this->components[] = 'EvBreadcrumb.Breadcrumb';
		}

		if (CakePlugin::loaded('EvCurrency')) {
			$this->components[] = 'EvCurrency.Currencies';
		}

		if (CakePlugin::loaded('EvTax')) {
			$this->components[] = 'EvTax.Taxable';
		}

		if (CakePlugin::loaded('EvInventory')) {
			$this->helpers[] = 'EvInventory.Inventory';
		}

		$this->helpers[] = 'EvShop.Products';
		$this->helpers['EvBreadcrumb.Breadcrumb'] = [];

		parent::__construct($request, $response);
	}

	/**
	 * Manages an admin edit form for this model
	 *
	 * @param integer $id ID of row to edit
	 * @return void
	 */
	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		parent::admin_edit($id);

		$this->set('variantImageSlots', $Model->variantImageSlots);
	}

	/**
	 * Fields used in the Variant edit page
	 */
	protected function _adminVariantManageFields() {
		return array(
			'Variant.id' => array(
				'type' => 'hidden'
			),
			'Variant.sequence' => array(
				'type' => 'hidden',
				'class' => 'sequence-input',
			),
			'Variant.option_desc' => array(
				'type' => 'string',
				'displayonly' => 'displayonly'
			),
			'Variant.name' => array(
				'type' => 'string'
			),
			'Variant.sku' => array(
				'type' => 'string'
			),
			'Variant.is_active' => array(
				'type' => 'boolean'
			)
		);
	}

	/**
	 * given the current category, get the parents for breadcrumbs
	 *
	 * @param 	array 	$category 		The current category
	 * @param 	array 	$categories 	Array of all categories (optional)
	 * @param 	bool 	$isProductPath 	Product Category path, set so we can set the url on first category
	 * @return 	bool
	 */
	protected function _getCategoryParentsBreadcrumb($category, $categories = array(), $isProductPath = false) {
		if (! empty($category['Category']['parent_id'])) {
			$parentId = $category['Category']['parent_id'];

			if (! empty($categories)) {
				$catList = $categories;
			} else {
				$CategoryModel = EvClassRegistry::init('EvShop.Category');
				$catList = $CategoryModel->getBreadcrumbList();
			}

			if (isset($catList[$parentId])) {
				$this->_getCategoryParentsBreadcrumb(
					$catList[$parentId],
					$catList
				);
			}
		}

		$url = null;
		if ((! empty($categories) || $isProductPath === true) && ! empty($category['Category']['id'])) {
			$url = $this->Routable->getItemRoute('EvShop', 'Category');
			$url[] = $category['Category']['id'];
		}

		if (! empty($category['Category']['name'])) {
			$this->Breadcrumb->addCrumb(
				$category['Category']['name'],
				$url
			);
		}

		return true;
	}

	/**
	 * given the product array get the categories breadcrumb
	 *
	 * @param 	array 	$product 	The product array
	 * @return 	bool
	 */
	protected function _getProductBreadcrumb($product) {
		krsort($product['CategoriesProduct']);

		$category = array_shift($product['CategoriesProduct']);

		$this->_getCategoryParentsBreadcrumb($category, array(), true);

		$this->Breadcrumb->addCrumb(
			$product['Product']['name']
		);

		return true;
	}

}
