$(document).ready(function() {
	$( ".deliverySlotPicker" ).datepicker({
		constrainInput: true,
		dateFormat: 'dd/mm/yy',
		beforeShowDay: checkIfDateSelectableDatePicker
	});
});

/**
 * For each date in the date picker, say if the date can be selected or not.
 * Can't order before today.
 * Can order up to 3pm today then earliest order date is tomorrow.
 * Can't order on sundays
 * @param  string date The date that will be displyed
 * @return array       An array containg if the date is selectable, an optional
 *                     class name and an optional tooltip
 */
function checkIfDateSelectableDatePicker(date) {
	//Not a way to get the name of the day in javascript without library so just make array.
	var weekdays = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

	//Set up the delivery slots if there are any
	var deliverySlots = [];
	if (typeof window.app !== 'undefined') {
		if (typeof window.app.deliverySlots !== 'undefined') {
			deliverySlots = window.app.deliverySlots;
		}
	}

	//Display the date by default
	var display = true;

	//Get the date now
	var dateNow = new Date();

	//Get the date of today (at midnight)
	var dateToday = new Date(dateNow.getFullYear() + '/' + (dateNow.getMonth() + 1) + '/' + dateNow.getDate());

	//Turn the passed date string into a date object
	var currentDate = new Date(date);
	var currentWeekDay = currentDate.getDay();

	//Don't display the date if it is in the past
	if (currentDate.getTime() < dateToday.getTime()) {
		display = false;
	}

	if (currentDate.getTime() == dateToday.getTime()) {
		//Find date in deliverySlots to find cutoff
		if (weekdays[currentWeekDay] in deliverySlots) {
			var cutoff = deliverySlots[weekdays[currentWeekDay]]['max_cutoff'];
			if (checkCutoff(cutoff, dateNow) === false) {
				display = false;
			}

			//check there isn't an overridden cutoff
			display = checkOverrideCutoffTime(display, weekdays[currentWeekDay], dateToday, dateNow);
		}
	}

	//Remove any sundays
	if (!(weekdays[currentDate.getDay()] in deliverySlots)) {
		display = false;
	}

	display = checkOverrideNoDelivery(display, weekdays[currentWeekDay], currentDate, dateNow);

	return [display, ''];
}

/**
 * Check if there is an overridden cutoff time and if there is display the current date based on the
 * override criteria.
 * @param  bool   currentCheck    What the current date display is so it can be returned without changing it.
 * @param  string currentWeekDay  The name of the current day. Used to lookup an override.
 * @param  Date   dateToday       The date of today timed at midnight.
 * @param  Date   dateNow         The date of today and the current time
 * @return bool                   Whether to display the current date or not.
 */
function checkOverrideCutoffTime(currentCheck, currentWeekDay, dateToday, dateNow) {
	if (typeof window.app !== 'undefined') {
		if (typeof window.app.overrideDeliverySlots !== 'undefined') {
			var overrideDeliverySlots = window.app.overrideDeliverySlots;

			if (currentWeekDay in overrideDeliverySlots) {
				var dateTodayString = dateAsDatabaseDateAndTimeString(dateToday);
				if (dateTodayString in overrideDeliverySlots[currentWeekDay]) {
					var cutoff = overrideDeliverySlots[currentWeekDay][dateTodayString]['max_cutoff'];
					if (checkCutoff(cutoff, dateNow) === false) {
						return false;
					} else {
						return true;
					}
				}
			}
		}
	}

	return currentCheck;
}

/**
 * Check if there is an overridden no delivery and if there is display the current date based on the
 * override criteria.
 * @param  bool   currentCheck    What the current date display is so it can be returned without changing it.
 * @param  string currentWeekDay  The name of the current day. Used to lookup an override.
 * @param  Date   currentDate     The current date being checked to display or not.
 * @return bool                   Whether to display the current date or not.
 */
function checkOverrideNoDelivery(currentCheck, currentWeekDay, currentDate) {
	if (typeof window.app !== 'undefined') {
		if (typeof window.app.overrideDeliverySlots !== 'undefined') {
			var overrideDeliverySlots = window.app.overrideDeliverySlots;

			if (currentWeekDay in overrideDeliverySlots) {
				var dateTodayString = dateAsDatabaseDateAndTimeString(currentDate);
				if (dateTodayString in overrideDeliverySlots[currentWeekDay]) {
					if(overrideDeliverySlots[currentWeekDay][dateTodayString]['no_delivery'] === true){
						return false;
					} else {
						return true;
					}
				}
			}
		}
	}

	return currentCheck;
}

/**
 * Compare a cutoff date and time to the current date and time
 * @param  string cutoff  The time of the cutoff
 * @param  Date   dateNow The date of today and the current time
 * @return bool           Returns false if the cutoff time has been reached
 */
function checkCutoff(cutoff, dateNow) {
	if (cutoff !== null) {
		//Create date from time and check against now
		var hoursMinutesSeconds = cutoff.split(':');
		var cutoffDate = new Date();
		cutoffDate.setHours(hoursMinutesSeconds[0]);
		cutoffDate.setMinutes(hoursMinutesSeconds[1]);
		cutoffDate.setSeconds(hoursMinutesSeconds[2]);

		if (dateNow.getTime() > cutoffDate.getTime()) {
			return false;
		}
	}
}

/**
 * Turn a date into a database formatted string.
 * @param  Date   date The date to convert to a database formatted string
 * @return string      The database formatted date string
 */
function dateAsDatabaseDateAndTimeString(date) {
	return date.getFullYear() + '-' +
		zeroBaseString((date.getMonth() + 1)) + '-' +
		zeroBaseString(date.getDate()) + ' ' +
		zeroBaseString(date.getHours()) + ':' +
		zeroBaseString(date.getMinutes()) + ':' +
		zeroBaseString(date.getSeconds());
}

/**
 * Make date values start with a 0 so that all date values have are the same length.
 * @param  int    integer The value to turn into a 2 character length string
 * @return string         The 0 based string
 */
function zeroBaseString(integer) {
	if (integer < 10 && integer > -10) {
		return '0' + integer;
	}
	return '' + integer;
}
