<?php
App::uses('ShippingRule', 'EvShipping.Model');

/**
 * ShippingRule Test Case
 */
class ShippingRuleTest extends CakeTestCase {

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.ev_shipping.shipping_rule',
		'plugin.ev_shipping.shipping_rule_data',
		'plugin.ev_shipping.zone',
		'plugin.ev_country.country',
		'plugin.ev_shipping.zone_extra',
		'plugin.ev_shipping.shipping_rules_zone'
	);

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$this->ShippingRule = ClassRegistry::init('EvShipping.ShippingRule');
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->ShippingRule);

		parent::tearDown();
	}

	public function testGetByZonesReturnsShippingRules() {
		$this->assertEquals(
			array(
				array(
					'ShippingRule' => array(
						'id' => 2,
						'name' => 'Weight Based UK None Mainland',
						'handler' => 'WorkingHandler',
						'sequence' => 1,
						'is_selectable' => 0,
						'is_active' => 1,
						'created' => '2015-09-03 09:45:31',
						'modified' => '2015-09-03 09:45:31'
					),
					'ShippingRuleData' => array(
						array(
							'id' => 2,
							'shipping_rule_id' => 2,
							'name' => 'weight_bands',
							'rule_data' => '1-10;15.00:11-20;20.00:21-99999999;30',
							'created' => '2015-09-03 09:45:58',
							'modified' => '2015-09-03 09:45:58'
						)
					)
				)
			),
			$this->ShippingRule->getByZones(array(3))
		);
	}

}
