<?php
App::uses('ShippingRuleData', 'EvShipping.Model');

/**
 * ShippingRuleData Test Case
 */
class ShippingRuleDataTest extends CakeTestCase {

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.ev_shipping.shipping_rule_data',
		'plugin.ev_shipping.shipping_rule',
		'plugin.ev_shipping.zone',
		'plugin.ev_country.country',
		'plugin.ev_shipping.zone_extra'
	);

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$this->ShippingRuleData = ClassRegistry::init('EvShipping.ShippingRuleData');
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->ShippingRuleData);

		parent::tearDown();
	}

	public function testformatForSaveFormatsTheGivenDataCorrect() {
		$this->assertEquals(
			array(
				array(
					'id' => '',
					'name' => 'weight_bands',
					'rule_data' => 'rule data here'
				)
			),
			$this->ShippingRuleData->formatForSave(
				array(
					'weight_bands' => array(
						'id' => '',
						'rule_data' => 'rule data here'
					)
				)
			)
		);
	}

	public function testgetByShippingRuleGetsTheDataAndFormatsCorrectly() {
		$this->assertEquals(
			array(
				'weight_bands' => array(
					'id' => 1,
					'shipping_rule_id' => 1,
					'name' => 'weight_bands',
					'rule_data' => '1-10;10.00:11-20;15.00:21-99999999;0',
					'created' => '2015-09-03 09:45:58',
					'modified' => '2015-09-03 09:45:58'
				)
			),
			$this->ShippingRuleData->getByShippingRule(1)
		);
	}

}
