<?php
App::uses('AbstractHandler', 'EvShipping.Lib');
App::uses('ComponentCollection', 'Controller');
App::uses('ShippingManagerComponent', 'EvShipping.Controller/Component');

// define handler so we can extend and test AbstractHandler
class ExampleHandler extends AbstractHandler {

	public function getRuleData() {
		return array();
	}

	public function processRule($ShippingRule) {
		return;
	}

}

/**
 * AbstractHandler Test Case
 */
class AbstractHandlerTest extends CakeTestCase {

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$Collection = new ComponentCollection();

		// mock the component to override the generateHash method so we can control it for testing
		$this->ShippingManager = new ShippingManagerComponent($Collection);

		$this->Handler = new ExampleHandler($this->ShippingManager);
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->Handler);

		parent::tearDown();
	}

	public function testFormatBandsFormatsPricingBandsCorrectly() {
		$this->assertEquals(
			array(
				array(
					'from' => 0,
					'to' => 10,
					'price' => 10.00
				),
				array(
					'from' => 10.01,
					'to' => 20,
					'price' => 15.00
				),
				array(
					'from' => 20.01,
					'to' => 99999,
					'price' => 0
				)
			),
			$this->Handler->formatBands(
				'0-10;10.00:10.01-20;15.00:20.01-99999;0'
			)
		);
	}

}
