<?php

App::uses('EvShippingAppModel', 'EvShipping.Model');

class OverrideDeliverySlot extends EvShippingAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'date';

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'DeliverySlot' => array(
			'className' => 'EvShipping.DeliverySlot'
		),
	);

/**
 * Return all the ovrridden delivery slots formatted so they are ordered by delivery slot and then by date.
 * @return array The array of formatted delivery slots
 */
	public function getOverrideDeliverySlots() {
		//return overriden delivery slots
		$overrideDeliverySlots = $this->find(
			'all',
			[
				'conditions' => [
					'OverrideDeliverySlot.is_active' => true
				],
				'contain' => [
					'DeliverySlot'
				]
			]
		);

		$results = [];
		foreach ($overrideDeliverySlots as $overrideDeliverySlot) {
			if (!empty($overrideDeliverySlot['DeliverySlot'])) {
				$results[$overrideDeliverySlot['DeliverySlot']['weekday']][$overrideDeliverySlot['OverrideDeliverySlot']['date']] = [
					'max_cutoff' => $overrideDeliverySlot['OverrideDeliverySlot']['max_cutoff'],
					'no_delivery' => $overrideDeliverySlot['OverrideDeliverySlot']['no_delivery'],
				];
			}
		}

		return $results;
	}
}
