<?php

App::uses('CakeEventListener', 'Event');

class EvShippingCheckForDiscountRestrictionsListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvBasket.Component.BasketDelivery.CheckDiscountRestrictions' => 'checkForDiscountRestrictions',
		);
	}

/**
 * Checks the basket for a delivery method which matches any ShippingRule code restrictions
 * that may be set within a discount rule
 *
 * @param 	CakeEvent
 */
	public function checkForDiscountRestrictions(CakeEvent $Event) {
		$result = array();

		if (isset($Event->data['discount']['code_restrictions'])
			&& ! empty($Event->data['discount']['code_restrictions'])) {

			// Restrictions were found
			$basket = $Event->data['basket'];
			$discount = $Event->data['discount'];

			// Default to invalidating the discount
			$result = array(
				'discountValue' => false
			);

			foreach ($discount['code_restrictions'] as $restriction) {
				// Find the shipping rule restriction and make sure it matches this baskets selected shipping rule
				if ($restriction['model'] == 'EvShipping.ShippingRule') {
					$BasketData = EvClassRegistry::init('EvBasket.BasketData');
					$shippingRule = $BasketData->find('first', array(
						'conditions' => array(
							'BasketData.basket_id' => $basket['id'],
							'BasketData.name' => "shipping_rule"
						)
					));

					if (empty($shippingRule['BasketData'])) {
						continue;
					}

					if ($shippingRule['BasketData']['data'] == $restriction['model_id']) {
						// The baskets shipping rule matches the discount/promotion restricted-to shipping rule
						$result = array(
							'discountValue' => true
						);
					}
				}
			}

			return $result;
		}
		return array();
	}
}
