<?php

abstract class AbstractHandler {

	/**
	 * return any field data that needs to be captured for the rule to function
	 *
	 * @return 	array
	 */
	abstract public function getRuleData();

	/**
	 * given the Rule and RuleData array - process the rule and return a rate or false on fail
	 *
	 * @param 	array 		$ShippingRule 	ShippingRule and ShippingRuleData
	 * @return 	float|bool 	$rate 			Bool false on fail or shipping rate
	 */
	abstract public function processRule($ShippingRule);

	/**
	 * define the constructor to accept ShippingManager by Reference
	 *
	 */
	public function __construct(&$ShippingManager) {
		$this->ShippingManager = $ShippingManager;
	}

	/**
	 * helper method to convert bands in the format from-to;price:from-to;price:from-to:from-to;price
	 * to a usable array
	 *
	 * @param 	string 		$unformattedBands 	The Unformatted shipping rule bands
	 * @return 	array 		$formattedBands 	The bands formatted into array for easier use
	 */
	public function formatBands($unformattedBands) {
		$bands = explode(':', $unformattedBands);

		$formattedBands = array_map(
			function ($bandPrice) {
				list($band, $price) = explode(';', $bandPrice);
				list($from, $to) = explode('-', $band);

				return array(
					'from' => $from,
					'to' => $to,
					'price' => $price
				);
			},
			$bands
		);

		return $formattedBands;
	}

	/**
	 * given a rule data name - return the data
	 *
	 * @param 	array 	$ShippingRuleData 	Array of ShippingRuleData
	 * @param 	string 	$name 				The rule data name
	 * @return 	mixed 	$ruleData 			The saved rule data
	 */
	public function getRuleDataItem($ShippingRuleData, $name) {
		if (empty($ShippingRuleData) || empty($name)) {
			return false;
		}

		$rules = Hash::combine($ShippingRuleData, '{n}.name', '{n}.rule_data');

		if (! isset($rules[$name])) {
			return false;
		}
		return $rules[$name];
	}
}
