<?php

App::uses('EvShippingAppController', 'EvShipping.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class ShippingRulesController extends EvShippingAppController {

	/**
	 * redefine to show the zone if applicable
	 *
	 * @return 	array
	 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$columns = ArrayUtil::addAfter(
			$columns,
			'ShippingRule.name',
			array(
				'Zone.{n}.name' => array(
					'type' => 'string',
					'label' => 'Zone',
					'default' => '-'
				),
				'ShippingRule.is_selectable' => array(
					'type' => 'boolean',
					'label' => 'Selectable'
				)
			)
		);

		return $columns;
	}

	/**
	 * redefine to pull countries
	 *
	 * @return array
	 */
	protected function _adminIndexPaginate() {
		$paginate = parent::_adminIndexPaginate();

		$paginate['contain'][] = 'Zone';

		return $paginate;
	}

	/**
	 * redefine to populate country dropdown
	 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$Zone = EvClassRegistry::init('EvShipping.Zone');

		$this->set(
			'zones',
			$Zone->getForDropdown()
		);

		if (Configure::read('EvShipping.enableDeliveryEstimates')) {
			$DeliverySlot = EvClassRegistry::init('EvShipping.DeliverySlot');
			$this->set(
				'deliverySlots',
				$DeliverySlot->getForDropdown()
			);
		}

		// get all the plugin based handlers and any custom application ones
		// prefix the plugin ones with EvShipping. so we know when loading
		$pluginHandlers = App::objects('EvShipping.ShippingHandlers');
		$pluginHandlersKeys = array_map(
			function ($element) {
				return 'EvShipping.' . $element;
			},
			$pluginHandlers
		);
		$appHandlers = App::objects('ShippingHandlers');

		$handlers = array(
			'EvShipping' => array_combine($pluginHandlersKeys, $pluginHandlers),
			'Application' => array_combine($appHandlers, $appHandlers),
		);
		$this->set(
			'handlers',
			$handlers
		);
	}

	/**
	 * redefine to add the multicheck zones options
	 *
	 * @return 	array
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields = ArrayUtil::addAfter(
			$fields,
			'ShippingRule.handler',
			array(
				'Zone' => array(
					'type' => 'multicheck'
				)
			)
		);

		$fields['ShippingRule.handler']['type'] = 'select';
		$fields['ShippingRule.handler']['class'] = 'ev-shipping-shipping-handler';

		// This will be included on the delivery estimates tab
		unset($fields['ShippingRule.lead_time']);

		return $fields;
	}

	/**
	 * redefine the admin_edit to setup the helper for the rule data tab
	 */
	public function admin_edit($id = null) {
		$this->toInject('helpers', 'EvShipping.RuleData');

		parent::admin_edit($id);

		$this->view = 'EvShipping.ShippingRules/admin_edit';
	}
}
