<?php

// register shippingHandlers as app paths so we can get objects
App::build(
	array(
		'ShippingHandlers' => array(
			'%s' . 'Lib' . DS . 'ShippingHandlers' . DS
		)
	),
	App::REGISTER
);

$path = dirname(__FILE__);
$pluginDir = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDir);
$pluginConfig = Inflector::underscore($pluginName);
Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';

if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {
	Configure::load($configOverride);
}

require_once (ROOT . DS . 'Plugin' . DS . 'EvShipping' . DS . 'Config' . DS . 'events.php');
