# EvShipping

## Installation

Simply add EvShipping to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvShipping`.

The installer will automatically setup the database tables and create 2 admin links for creating shipping rules and shipping zones.

## How it works

The shipping plugin works by creating Zones which are tagged to a country and any zone extras, these are conditions upon which you can help filter different zones for different addresses.

Once matching zone(s) have been found, it loads all the shipping rules attached to those zones ordered by the defined sequence on shipping rules.

The rule data is loaded along with the rule handler that is defined on that rule, the rule data (price bands and such) is then passed into the handler. The handler should then processes the rule data and any other data that was passed into the handler to return the found price rate for shipping.

Once found, any final surcharges are applied that have been stored on the shipping component.

## Setup

Once the installer has run, setup is relatively quick unless a new shiping handler is needed.

Vist the links within the admin area and create a new zone by selecting the country to which this zone belongs and giving it a name, this is so the site admin can identify which zone is which when tagging Shipping Rules to them. In the zone extras tab things such as post codes conditions can be added.

When adding zone extras, the field name must map to the address field name (e.g. post_code). If the LIKE operator was selected a percentage sign can be used as a wildcard (like in MySQL). This can help management of zone extras has not every post code will have to be entered and you can simply target 'S3' rather then 'S3 7BH', 'S3 7AH' etc...

Once all zones have been added, add a new shipping rule by giving it a name, selecting which handler it uses and tagging which zones it should belong to. Once that is done switch to the Rule Data tab. The contents of this tab is populated by the shipping handler you have selected, as part of the creation of these you can define all the data that the handler will need in order to process the shipping, usually this will consist of weight bands or price bands.

While not implemented the 'Is Selectable' flag was put in place for those instances where a shop may let a user select which shipping rule they wish to choose at checkout.

## Shipping Handlers

Shipping handlers are created by placing them within either `/app/Lib/ShippingHandlers` or `/Plugin/PluginName/Lib/ShippingHandlers`. Following CakePHP standard the filename should be CamelCased and should match the class name inside. The class must also extend the AbstractHandler, this sets abstract methods which you must extend in order to have a fully functional handler and also provide some extra features to make life easier when developing the rule.

Below is a minimal example of what would be needed to create another shipping handler

	<?php

	App::uses('AbstractHandler', 'EvShipping.Lib');

	class AmountTotalsHandler extends AbstractHandler {

		/**
		 * return any field data that needs to be captured for the rule to function
		 *
		 * @return 	array
		 */
		public function getRuleData() { }

		/**
		 * given the Rule and RuleData array - process the rule and return a rate or false on fail
		 *
		 * @param 	array 		$ShippingRule ShippingRule and ShippingRuleData
		 * @return 	float|bool 	$rate 	Bool false on fail or shipping rate
		 */
		public function processRule($ShippingRule) { }

	}

The `getRuleData()` method is the one in which you define all the data that this shipping handler will need in order to complete the process of the shipping rule. Using the bundled `AmountTotalsHandler` as an example below is the `getRuleData()` method from that class.

	public function getRuleData() {
		return array(
			'total_bands' => array(
				'type' => 'text_plain',
				'label' => 'Total Bands',
				'displayInfo' => 'Enter bands in the format: from-to;price:from-to;price:from-to:from-to;price'
			),
			'postcode_surcharge' => array(
				'type' => 'string',
				'label' => 'Postcode Surcharge',
				'between' => '<strong>&pound;</strong>'
			)
		);
	}

The `processRule()` method is the main method which processes the rule. What happens within this method depends upon what needs to happen with your rule. The method accepts the array of data from ShippingRule and the ShippingRuleData models.

Below is a copy of the `processRule()` method from the `AmountTotalsHandler`

	public function processRule($ShippingRule) {
		$rate = false;

		// get the total bands and format into array
		$bands = $this->getRuleDataItem($ShippingRule['ShippingRuleData'], 'total_bands');

		if (empty($bands)) {
			return false;
		}
		$bands = $this->formatBands($bands);

		// get the total amount
		$totalAmount = $this->ShippingManager->getData('total-amount');

		if ($totalAmount === false || is_null($totalAmount)) {
			return false;
		}

		// loop the bands and find ours
		foreach ($bands as $bandInfo) {
			if ($totalAmount >= $bandInfo['from'] && $totalAmount <= $bandInfo['to']) {
				$rate = $bandInfo['price'];
			}
		}

		// check if there is a surcharge set - usually for post codes in certain areas (e.g. scottish highlands)
		$surcharge = $this->getRuleDataItem($ShippingRule['ShippingRuleData'], 'postcode_surcharge');

		if ($surcharge > 0) {
			$this->ShippingManager->addSurcharge('postcode-surcharge', $surcharge);
		}

		return $rate;
	}

From that method you can either return a float number to be used as the shipping rate or false to say it failed finding a rate.

If for a custom shipping rule, you use the same price band entry method of `from-to;price:from-to;price` there is a method available as part of the base AbstractHandler method that automatically explodes this out into an array similar to this, allowing you to work with it and compare bands and retrieve rate data

	array(
		array(
			'from' => 0,
			'to' => 10,
			'price' => 10.00
		),
		array(
			'from' => 10.01,
			'to' => 20,
			'price' => 15.00
		),
		array(
			'from' => 20.01,
			'to' => 99999,
			'price' => 0
		)
	)

###Weight-based Shipping
As of version 2.2.1.1 EvShipping has a weight-based shipping handler built in. It does not however work out of the box.

In your custom EvCheckoutPreStageComponent you need to provide the total-weight value to the shipping handler.

Since this is not a simple field that's available in the checkout, it's down to you to figure out how to actually get that data through to EvShipping.

It was added for ArtisticFlair so take a look at how that one works. In a nutshell it just loops through the basket items, and goes into the arrays of each item to pull out a weight variable (a custom field added to the ev shop products table) and adds them all up to work out the total weight. This then gets passed to the shipping handler using:

    $this->_controller->ShippingManager->addData('total-weight', $weight);

## ShippingManager

The shipping manager component is available within shipping handlers at `$this->ShippingManager`, this class also handles all any surcharges that want to be added. From within the `ShippingHandler` you can access these to add new ones or remove them. **DO NOT** process any surcharges within here that are already added to the ShippingManager as they may be added twice and therefore overcharging the customer.

The `ShippingManager` also provides addData / getData methods. There are used to assign arbitrary data to the shipping manager and therefore also the shipping handler. The basket / checkout processes uses these methods to add a copy of the Basket array to the `ShippingManager` so that within the `ShippingHandler` we can access the basket totals and compare against the defined price bands to find the correct shipping rate.

## Delivery Slots
Delivery slots are used to create restrictions when a user is selecting a delivery or collection date. The basic slots cover the days of week and by default allow a user to select same day delivery up to 1pm and any day can be selected. Delivery slots can be editted in the CMS, just add a menu item with a url of`/admin/ev_shipping/delivery_slots`.

Delivery slots can be overridden for specific days e.g. bank holidays. Overridden delivery slots have the same options as delivery slots so the cutoff time can be editted and whether delivery is available on that day or not. To edit them in the CMS add a menu item with a url of `/admin/ev_shipping/override_delivery_slots`.

To create a datepicker with these restrictions, an element has been created that creates a simple datepicker and loads the required javascript file. It also by default attempts to write the delivery slots and overridden delivery slots to javascript variables.

The slots can be passed to javascript variables by using the shipping manager component to obtain the delivery and overridden delivery slots and setting them into `deliverySlots` and `overrideDeliverySlots` respectively.

Validation of a delivery slot can be done using the deliverySlot model validation. For example the following code is used in the checkout on Monica F Hewitt:

	$DeliverySlotModel = EvClassRegistry::init('EvShipping.DeliverySlot');
	$DeliverySlotModel->set(['date' => $data['deliveryDate']]);
	$DeliverySlotModel->validate = $DeliverySlotModel->deliverySlotDateValidation();
	if (!$DeliverySlotModel->validates()) {
		$validationErrors = [];
		foreach ($DeliverySlotModel->validationErrors as $field => $error) {
			$validationErrors['Delivery'][$field] = $error[0];
		}

		$errors = array(
			'description' => 'There are issues with your order date. Please check it and try again.',
			'list' => $validationErrors
		);
		$this->_controller->Flash->fail($errors);

		return false;
	}

The delivery slot validation checks for overridden delivery slots as well so they don't need to be checked separately.

## Delivery Estimates

An estimated delivery date can be found using `DeliverySlot::estimateDeliveryDate( $leadTimeInDays, $dateFormat = 'd/m/Y', $limitToDeliverySlotIds = null )`

If `EvShipping.enableDeliveryEstimates` is set to true, an additional tab will be available when editing a `ShippingRule` in the CMS to store the `lead_time` for this method and what slots to restrict delivery to when estimating. If all delivery slots are left unchecked no restriction is applied. This data can be passed to the above function to generate a delivery date estimate.

