<?php
/**
 * Zone Fixture
 */
class ZoneFixture extends CakeTestFixture {

	public $table = 'ev_shipping_zones';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'country_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'country_id' => 1,
			'name' => 'UK Zone',
			'is_active' => 1,
			'created' => '2015-09-03 09:27:30',
			'modified' => '2015-09-03 09:27:30'
		),
		array(
			'id' => 2,
			'country_id' => 2,
			'name' => 'US Zone',
			'is_active' => 1,
			'created' => '2015-09-03 09:27:30',
			'modified' => '2015-09-03 09:27:30'
		),
		array(
			'id' => 3,
			'country_id' => 1,
			'name' => 'None Mainland UK',
			'is_active' => 1,
			'created' => '2015-09-03 09:27:30',
			'modified' => '2015-09-03 09:27:30'
		),
	);

}
