<?php
/**
 * ShippingRuleData Fixture
 */
class ShippingRuleDataFixture extends CakeTestFixture {

	public $table = 'ev_shipping_shipping_rule_data';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'shipping_rule_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'rule_data' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_shipping_rule_data_shipping_rules1_idx' => array('column' => 'shipping_rule_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'shipping_rule_id' => 1,
			'name' => 'weight_bands',
			'rule_data' => '1-10;10.00:11-20;15.00:21-99999999;0',
			'created' => '2015-09-03 09:45:58',
			'modified' => '2015-09-03 09:45:58'
		),
		array(
			'id' => 2,
			'shipping_rule_id' => 2,
			'name' => 'weight_bands',
			'rule_data' => '1-10;15.00:11-20;20.00:21-99999999;30',
			'created' => '2015-09-03 09:45:58',
			'modified' => '2015-09-03 09:45:58'
		)
	);

}
