<?php
App::uses('Zone', 'EvShipping.Model');

/**
 * Zone Test Case
 */
class ZoneTest extends CakeTestCase {

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.ev_shipping.zone',
		'plugin.ev_country.country',
		'plugin.ev_shipping.zone_extra',
		'plugin.ev_shipping.shipping_rule',
		'plugin.ev_shipping.shipping_rules_zone'
	);

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$this->Zone = ClassRegistry::init('EvShipping.Zone');

		$this->address = array(
			'address1' => 'Evoluted New Media',
			'address2' => '35 Lambert Street',
			'city' => 'Sheffield',
			'post_code' => 'S3 7BH'
		);

		$this->searches = array(
			'exact' => array(
				'field' => 'post_code',
				'operator' => '=',
				'field_value' => 'S3 7BH'
			),
			'exactLower' => array(
				'field' => 'post_code',
				'operator' => '=',
				'field_value' => 's3 7bh'
			),
			'wildcardEnd' => array(
				'field' => 'post_code',
				'operator' => 'LIKE',
				'field_value' => 'S3%'
			),
			'wildcardStart' => array(
				'field' => 'post_code',
				'operator' => 'LIKE',
				'field_value' => '%7BH'
			),
			'wildcardBoth' => array(
				'field' => 'post_code',
				'operator' => 'LIKE',
				'field_value' => '%7B%'
			)
		);
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->Zone);

		parent::tearDown();
	}

	public function testGetByCountryReturnsZonesCorrectlyWhenGivenACountryId() {
		$this->assertEquals(
			array(
				array(
					'Zone' => array(
						'id' => 1,
						'country_id' => 1,
						'name' => 'UK Zone',
						'is_active' => 1,
						'created' => '2015-09-03 09:27:30',
						'modified' => '2015-09-03 09:27:30'
					),
					'ZoneExtra' => array()
				),
				array(
					'Zone' => array(
						'id' => 3,
						'country_id' => 1,
						'name' => 'None Mainland UK',
						'is_active' => 1,
						'created' => '2015-09-03 09:27:30',
						'modified' => '2015-09-03 09:27:30'
					),
					'ZoneExtra' => array(
						array(
							'id' => 1,
							'zone_id' => 3,
							'field' => 'post_code',
							'operator' => 'LIKE',
							'field_value' => 'S6%',
							'created' => '2015-09-03 09:28:45',
							'modified' => '2015-09-03 09:28:45'
						),
						array(
							'id' => 2,
							'zone_id' => 3,
							'field' => 'post_code',
							'operator' => '=',
							'field_value' => 'S3 7BH',
							'created' => '2015-09-03 09:28:45',
							'modified' => '2015-09-03 09:28:45'
						)
					)
				)
			),
			$this->Zone->getByCountry(1)
		);
	}

	public function testzoneExtraMatchMatchesStringsCorrectly() {
		$this->assertTrue(
			$this->Zone->zoneExtraMatch(
				$this->searches['exact'],
				$this->address
			)
		);

		$this->assertTrue(
			$this->Zone->zoneExtraMatch(
				$this->searches['exactLower'],
				$this->address
			)
		);

		$this->assertTrue(
			$this->Zone->zoneExtraMatch(
				$this->searches['wildcardEnd'],
				$this->address
			)
		);

		$this->assertTrue(
			$this->Zone->zoneExtraMatch(
				$this->searches['wildcardStart'],
				$this->address
			)
		);

		$this->assertTrue(
			$this->Zone->zoneExtraMatch(
				$this->searches['wildcardBoth'],
				$this->address
			)
		);
	}

	public function testFilterOnExtrasWillReturnTheCorrectZones() {
		$ukZones = $this->Zone->getByCountry(1);

		$this->assertEquals(
			array(
				array(
					'Zone' => array(
						'id' => 3,
						'country_id' => 1,
						'name' => 'None Mainland UK',
						'is_active' => 1,
						'created' => '2015-09-03 09:27:30',
						'modified' => '2015-09-03 09:27:30'
					),
					'ZoneExtra' => array(
						array(
							'id' => 1,
							'zone_id' => 3,
							'field' => 'post_code',
							'operator' => 'LIKE',
							'field_value' => 'S6%',
							'created' => '2015-09-03 09:28:45',
							'modified' => '2015-09-03 09:28:45'
						),
						array(
							'id' => 2,
							'zone_id' => 3,
							'field' => 'post_code',
							'operator' => '=',
							'field_value' => 'S3 7BH',
							'created' => '2015-09-03 09:28:45',
							'modified' => '2015-09-03 09:28:45'
						)
					)
				)
			),
			$this->Zone->filterOnExtras(
				$ukZones,
				$this->address
			)
		);

		$address = $this->address;
		$address['post_code'] = 'AA1 1AA';
		$this->assertEquals(
			array(
				array(
					'Zone' => array(
						'id' => 1,
						'country_id' => 1,
						'name' => 'UK Zone',
						'is_active' => 1,
						'created' => '2015-09-03 09:27:30',
						'modified' => '2015-09-03 09:27:30'
					),
					'ZoneExtra' => array()
				),
			),
			$this->Zone->filterOnExtras(
				$ukZones,
				$address
			)
		);
	}
}
