<?php
App::uses('EvShippingAppModel', 'EvShipping.Model');
/**
 * ZoneExtra Model
 *
 * @property Zone $Zone
 */
class ZoneExtra extends EvShippingAppModel {

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'field';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'zone_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => 'A zone must be selected for this extra data'
			),
		),
		'field' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'A field name must be entered to link this data to'
			),
		),
		'field_value' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Field value must be entered to search for'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

	/**
	 * belongsTo associations
	 *
	 * @var array
	 */
	public $belongsTo = array(
		'Zone' => array(
			'className' => 'EvShipping.Zone'
		)
	);
}
