<?php
App::uses('EvShippingAppModel', 'EvShipping.Model');
/**
 * ShippingRuleData Model
 *
 * @property ShippingRule $ShippingRule
 */
class ShippingRuleData extends EvShippingAppModel {

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'name';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'shipping_rule_id' => array(
			'numeric' => array(
				'rule' => array('numeric')
			),
		),
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'A name for the data must be entered'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

	/**
	 * belongsTo associations
	 *
	 * @var array
	 */
	public $belongsTo = array(
		'ShippingRule' => array(
			'className' => 'EvShipping.ShippingRule'
		),
		'Currency' => array(
			'className' => 'EvCurrency.Currency'
		)
	);

	/**
	 * get the shipping rule data given the rule id
	 *
	 * @param 	int 	$shippingRuleId 	The rule ID number
	 * @return 	array 	$ruleData 			Array of the rule data
	 */
	public function getByShippingRule($shippingRuleId) {

		$data = array();
		$currencies = $this->Currency->find('all');

		foreach ($currencies as $currency) {
			$ruleData = $this->find(
				'all',
				array(
					'conditions' => array(
						'ShippingRuleData.shipping_rule_id' => $shippingRuleId,
						'ShippingRuleData.currency_id' => $currency['Currency']['id'],

					)
				)
			);

			$data[$currency['Currency']['id']] = Hash::combine(
				$ruleData,
				'{n}.ShippingRuleData.name',
				'{n}.ShippingRuleData'
			);
		}

		return $data;
	}

	/**
	 * used by the ShippingRule model to format rule data for saving
	 *
	 * @param 	array 	$ruleData 			Array of ruledata from the form
	 * @return 	array 	$shippingRuleData 	Formated data ready for saving
	 */
	public function formatForSave($ruleData) {
		$shippingRuleData = array();

		foreach ($ruleData as $currencyId => $rule) {
			foreach ($rule as $field => $data) {

				$shippingRuleData[] = array(
					'id' => $data['id'],
					'name' => $field,
					'rule_data' => $data['rule_data'],
					'currency_id' => $data['currency_id']
				);
			}
		}

		return $shippingRuleData;
	}
}
