<?php

App::uses('AbstractHandler', 'EvShipping.Lib');

class AmountTotalsHandler extends AbstractHandler {

	/**
	 * define the getRuleData method to tell the rule we want weight bands
	 *
	 * @return array
	 */
	public function getRuleData() {
		$currencies = Configure::read('currencies');

		if (isset($currencies) && ! empty($currencies)) {

			$fields = array();

			foreach ($currencies as $currencyId => $currencyName) {
				$fields[$currencyId] =  array(
					'total_bands' => array(
						'type' => 'text_plain',
						'label' => 'Total Bands',
						'displayInfo' => 'Enter bands in the format: from-to;price:from-to;price:from-to:from-to;price'
					),
					'postcode_surcharge' => array(
						'type' => 'string',
						'label' => 'Postcode Surcharge'
					)
				);
			}

			return $fields;

		} else {
			die('Please configure your system currencies.');
		}


	}

	public function processRule($ShippingRule) {
		$rate = false;

		// get the total bands and format into array
		$bands = $this->getRuleDataItem($ShippingRule['ShippingRuleData'], 'total_bands');

		if (empty($bands)) {
			return false;
		}
		$bands = $this->formatBands($bands);

		// get the total amount
		$totalAmount = $this->ShippingManager->getData('total-amount');

		if ($totalAmount === false || is_null($totalAmount)) {
			return false;
		}

		// loop the bands and find ours
		foreach ($bands as $bandInfo) {
			if ($totalAmount >= $bandInfo['from'] && $totalAmount <= $bandInfo['to']) {
				$rate = $bandInfo['price'];
			}
		}

		// check if there is a surcharge set - usually for post codes in certain areas (e.g. scottish highlands)
		$surcharge = $this->getRuleDataItem($ShippingRule['ShippingRuleData'], 'postcode_surcharge');

		if ($surcharge > 0) {
			$this->ShippingManager->addSurcharge('postcode-surcharge', $surcharge);
		}

		return $rate;
	}
}
