<?php

App::uses('EvShippingAppController', 'EvShipping.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class ZonesController extends EvShippingAppController {

	/**
	 * redefine to populate country dropdown
	 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$Country = EvClassRegistry::init('EvCountry.Country');

		$this->set('countries', $Country->find('list'));
	}

	/**
	 * redefine to add country multicheck
	 * @return array fields
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminformFields();

		$fields['Country'] = array(
			'type' => 'multicheck',

		);

		return $fields;
	}

	/**
	 * redefine admin_edit to add the zone extras tab
	 */
	public function admin_edit($id = null) {
		$this->toInject['helpers']['ZoneExtras'] = 'EvShipping.ZoneExtras';

		parent::admin_edit($id);
	}
}
