<?php

App::uses('EvShippingAppController', 'EvShipping.Controller');

class ShippingRuleDataController extends EvShippingAppController {

	/**
	 * ajax method to get the rule data for the given handler
	 *
	 * @param 	string 	handler to load
	 * @return 	string
	 */
	public function ajax_getFields($shippingHandler, $shippingRuleId = null) {
		list($plugin, $handler) = pluginSplit($shippingHandler, true, '');

		App::uses($handler, $plugin . 'ShippingHandlers');

		$ShippingManager = $this->loadComponent('EvShipping.ShippingManager');
		$ShippingHandler = new $handler(
			$ShippingManager
		);

		$this->set(
			'fields',
			$ShippingHandler->getRuleData()
		);

		if (! empty($shippingRuleId)) {
			$this->request->data['RuleData'] = $this->ShippingRuleData->getByShippingRule($shippingRuleId);
		}

		$this->theme = 'admin';
		$this->layout = false;
	}
}
