<?php

App::uses('EvShippingAppController', 'EvShipping.Controller');

class DeliverySlotsController extends EvShippingAppController {

	public function beforeFilter() {
		$this->adminActions[] = 'admin_edit_slots';
		unset($this->adminActions[array_search('admin_edit', $this->adminActions)]);
		unset($this->adminActions[array_search('admin_delete', $this->adminActions)]);
		parent::beforeFilter();
	}

	protected function _adminIndexToolbar() {
		$toolbar = parent::_adminIndexToolbar();

		if (isset($toolbar['Add New'])) {
			unset($toolbar['Add New']);
		}

		$toolbar['Edit Delivery Slots'] = [
			'url' => [
				'action' => 'edit_slots'
			],
			'class' => 'toolbar__btn--edit'
		];

		return $toolbar;
	}

	protected function _adminIndexColumns() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumns();

		if (isset($columns[$modelAlias . '.id'])) {
			unset($columns[$modelAlias . '.id']);
		}

		return $columns;
	}

	protected function _adminIndexColumnsWhitelist() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumnsWhitelist();

		if ($Model->hasField('max_cutoff')) {
			$columns[] = "$modelAlias.max_cutoff";
		}

		if ($Model->hasField('no_delivery')) {
			$columns[] = "$modelAlias.no_delivery";
		}

		return $columns;
	}

/**
 * Defines which actions are available to each row of the admin_index table results
 *
 * Override in your controller to customise
 * Customise the handlers for these actions in /view/Admin/Elements/index_results.ctp
 *
 * @return array
 */
	protected function _adminIndexActions() {
		$actions = parent::_adminIndexActions();

		if (isset($actions['Edit'])) {
			unset($actions['Edit']);
		}

		if (isset($actions['Delete'])) {
			unset($actions['Delete']);
		}

		return $actions;
	}

/**
 * An edit page that allows all the delivery slots to be editted at once.
 */
	public function admin_edit_slots() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		if ($this->request->is('post') || $this->request->is('put')) {

			if ($Model->saveMany($this->request->data['DeliverySlot'])) {

				// save was successful
				$this->Flash->success(
					array(
						'title' => 'Save Successful',
						'description' => 'Delivery slots been saved successfully'
					)
				);

				// check whether to redirect to product listing or pricing page again
				if (isset($this->request->data['return']) && $this->request->data['return'] == 1) {

					$this->Session->write("Admin.$modelAlias.return", true);
					$return = array(
						'action' => 'edit_slots'
					);
				} else {

					$this->Session->delete("Admin.$modelAlias.return");

					$redirect = $this->Session->read("Admin.$modelAlias.filter");
					if (strpos($redirect, 'Filter') !== false) {
						$return = $redirect;
					} else {
						if (in_array('EvShippingDeliverySlots', App::objects('Controller'))) {
							$return = array(
								'plugin' => false,
								'controller' => 'ev_shipping_delivery_slots',
							);
						} else {
							$return = array(
								'plugin' => 'ev_shipping',
								'controller' => 'delivery_slots'
							);
						}
						$return['action'] = 'index';
					}
				}

				$this->redirect($return);

			} else {
				// uh oh, fail.
				$this->Flash->fail(
					array(
						'title' => 'Save Failed',
						'description' => 'There was a problem saving the delivery slots. Please check that you have entered valid cutoff times (HH::mm).'
					)
				);
			}

		}

		$this->request->data['DeliverySlot'] = $Model->readForEditSlots();

		$actionLabel = 'Manage';
		$this->set(
			array(
				'actionLabel' => $actionLabel,
				'title_for_layout' => $actionLabel . ' ' . InflectorExt::humanize($Model->displayName),
			)
		);

		$this->view = 'EvShipping./DeliverySlots/admin_edit_slots';
	}
}
