<?php

App::uses('PluginInstallShell', 'shells');

class EvShippingInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvNavigation.Menu',
		'EvShipping.DeliverySlot'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		// Add to the admin menu
		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => 1,
					'name' => 'Shipping',
					'pattern' => '/^\/admin\/ev_shipping\/shipping_rules\//',
					'plugin' => 'EvShipping',
					'controller' => 'ev_shipping.shipping_rules',
					'model' => 'ShippingRule',
					'action' => 'index',
					'class' => 'icon-truck',
					'is_active' => 1
				)
			)
		);
		$parentId = $this->Menu->getInsertID();
		$this->Menu->clear();
		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => $parentId,
					'name' => 'Zones',
					'pattern' => '/^\/admin\/ev_shipping\/zones\//',
					'plugin' => 'EvShipping',
					'controller' => 'ev_shipping.zones',
					'model' => 'Zone',
					'action' => 'index',
					'is_active' => 1
				)
			)
		);

		$this->DeliverySlot->saveMany(
			array(
				array(
					'weekday' => 'Monday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
				array(
					'weekday' => 'Tuesday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
				array(
					'weekday' => 'Wednesday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
				array(
					'weekday' => 'Thursday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
				array(
					'weekday' => 'Friday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
				array(
					'weekday' => 'Saturday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
				array(
					'weekday' => 'Sunday',
					'no_delivery' => 0,
					'max_cutoff' => '13:00:00'
				),
			)
		);
	}
}
