<?php
class AddDeliveryEstimates extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_delivery_estimates';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'ev_shipping_delivery_slots' => array(
					'weekday' => array('type' => 'string', 'null' => false, 'default' => 'Sunday', 'length' => 9, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
				),
			),
			'create_table' => array(
				'ev_shipping_delivery_slots_shipping_rules' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'shipping_rule_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'delivery_slot_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
			),
			'create_field' => array(
				'ev_shipping_shipping_rules' => array(
					'lead_time' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'handler'),
				),
			),
		),
		'down' => array(
			'alter_field' => array(
				'ev_shipping_delivery_slots' => array(
					'weekday' => array('type' => 'string', 'null' => false, 'default' => 'Sunday', 'length' => 9, 'unsigned' => false),
				),
			),
			'drop_table' => array(
				'ev_shipping_delivery_slots_shipping_rules'
			),
			'drop_field' => array(
				'ev_shipping_shipping_rules' => array('lead_time'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
