<?php

use Faker\Factory;
use Faker\Generator;

App::uses('ShellModelTruncator', 'FakeSeeder.Lib');
App::uses('ShellSeedProcessor', 'FakeSeeder.Lib');

class EvSeederTaskCore extends AppShell {

	public $faker = null;

	protected $_seedNumber = null;

	protected $_locale = null;

	public function execute() {
		$this->_getFaker();
	}

	public function setSeedingNumber() {
		if (!empty($this->_seedNumber)) {
			return true;
		}

		$seedNumber = Configure::read('EvSeeder.seedNumber');
		$this->_seedNumber = (!empty($seedNumber) && $seedNumber != 'random') ? $seedNumber : rand(1, 99999);
	}

	public function setLocale() {
		if (!empty($this->_locale)) {
			return true;
		}

		$locale = Configure::read('EvSeeder.locale');
		$this->_locale = (!empty($locale)) ? $locale : 'en_US';
	}

	protected function _getFaker() {
		$this->setLocale();
		$this->setSeedingNumber();

		$this->faker = Factory::create($this->_locale);
		$this->faker->seed($this->_seedNumber);

		return $this->faker;
	}
}