<?php

App::uses('EvSeederTaskCore', 'EvSeeder.Console');

class SeedTask extends EvSeederTaskCore {

	public function run($results) {
		parent::execute();

		foreach ($results as $result) {
			$plugin = $result['plugin'];
			$model = $result['model'];
			$seedCount = $result['values']['seeds'] ?? null;
			$fields = $result['values']['fields'];
			$truncate = $result['values']['truncate'] ?? false;

			$key = $plugin . '.' . $model;

			// create seeds
			$seeds = $this->_createSeeds($model, $seedCount, $fields);
			$Class = EvClassRegistry::init($key);

			if ($truncate) {
				$table = $Class->tablePrefix . $Class->useTable;
				if (!empty($table)) {
					$Class->query('TRUNCATE ' . $table . ';');
					$this->out($table . ' TRUNCATED');

				}
			}

			try {
				if ($Class->saveMany($seeds, ['callback' => false, 'validate' => false, 'deep' => 1])) {
					$this->out($seedCount . ' seeds added to ' . $key);
				} else {
					$this->out($seedCount . ' seeds failed to save to ' . $key);
				}
			} catch (\Exception $e) {
				die($e->getMessage());
			}
		}
	}

	protected function _createSeeds($model, $seedCount, $fields) {
		$return = [];

		for ($i = 1; $i <= $seedCount; $i++) {
			$return[$i] = [];
			foreach ($fields as $key => $field) {
				$values = $this->_getValues($field);

				$return[$i][$model][$key] = $values;
			}

			if ($model == 'Product') {
				$return[$i]['return'] = 0;
				$return[$i]['addNew'] = 1;
				$return[$i]['Route'] = ['id' => '', 'alias' => ''];
				$return[$i]['MetaData'] = ['id' => '', 'title' => '', 'description' => ''];
			}
		}

		return $return;
	}

	protected function _getValues($field) {
		$values = [];
		$methods = explode('|', $field);

		foreach ($methods as $method) {
			$parameters = explode(':', $method);
			$classMethod = array_shift($parameters);

			$fakerResult = $this->_getFakerResult($classMethod, $parameters);

			$result = $this->_handleResult($classMethod, $fakerResult, $parameters);
			if (!empty($result)) {
				$values[] = $result;
			}
		}

		return implode(' ', $values);
	}

	protected function _handleResult($classMethod, $result, $parameters = null) {
		switch ($classMethod) {
			case 'setValue':
				$result = (!empty($parameters[0])) ? $parameters[0] : '';
				break;
			case 'relationshipById':
				$Class = EvClassRegistry::init($parameters[0]);
				$result = null;
				if ($Class) {
					$randomResult = $Class->find('first', ['order' => 'RAND()']);

					$pluginSplit = explode('.', $parameters[0]);

					$result = $randomResult[$pluginSplit[1]]['id'];
				}
				break;
			case 'paragraph':
				$result = '<p>' . $result . '</p>';
				break;
			case 'paragraphs':
				$result = '<p>' . implode('</p><p>', $result) . '</p>';
				break;
		}

		if (is_array($result)) {
			$result = implode(' ', $result);
		} elseif ($result == 0) {

		} elseif (empty($result)) {
			$result = null;
		}

		return $result;
	}

	protected function _getFakerResult($classMethod, $parameters) {
		try {
			$result = call_user_func_array([$this->faker, $classMethod], $parameters);
		} catch (\Exception $e) {
			$result = null;
		}

		return $result;
	}
}
