<?php

App::uses('AppShell', 'Console/Command');

class SeedShell extends AppShell {

	public $plugins = [];

	public $results = [];

	public $resultsTable = null;

	public $tasks = ['EvSeeder.Seed'];

	public function main() {
		$this->out("\nDisplay help\n");
	}

	public function generate() {
		// check if a plugin has been specified
		$onlyTryThisPlugin = (!empty($this->args[0])) ? $this->args[0] : null;

		// if only one plugin has been specified check that, else check them all
		(!empty($onlyTryThisPlugin)) ? $this->__checkSinglePlugin($onlyTryThisPlugin) : $this->__checkAllPlugins();
		$this->out(count($this->plugins) . ' plugin' . (count($this->plugins) > 1 || empty($this->plugins) ? 's' : '') . ' found');
		$this->hr(1);

		if (!empty($this->plugins) && is_array($this->plugins)) {

			$this->__sortResults();
			$this->__displayTable();
			if (empty($this->resultsTable['valid'])) {
				$this->out('There\'s nothing to be seeded');
				exit();
			}
			$proceed = $this->in('Are you sure you want to seed these databases?', ['Yes', 'No']);
			if (in_array(strtolower($proceed), ['y', 'yes']) !== false) {
				$this->Seed->run($this->results);
			}
		}
	}

	private function __checkSinglePlugin($pluginToCheck) {
		$this->out('Looking for: ' . $pluginToCheck);

		// spit the plugin
		list($plugin, $model) = explode('.', $pluginToCheck);

		// check the location
		$config = Configure::read($plugin . '.EvSeedable.' . $model);
		if ($config) {
			// add to array
			$this->plugins[$plugin][$model] = $config;
		}
	}

	private function __checkAllPlugins() {
		$this->out('Checking plugins for seed configs');

		$plugins = App::objects('plugin');

		// loop through the plugins and check if they've got a seedable config
		foreach ($plugins as $plugin) {
			$config = Configure::read($plugin . '.EvSeedable');
			if ($config) {
				$this->plugins[$plugin] = $config;
			}
		}
	}

	private function __sortResults() {
		$this->resultsTable['valid'] = [
			['Plugin', 'Model', 'Seeds', 'Fields', 'Truncate before seed'],
		];

		$this->resultsTable['invalid'] = [
			['Plugin', 'Model', 'Reason Failed'],
		];

		if (!empty($this->plugins) && is_array($this->plugins)) {
			// sorry if there's a better way to do this with hash
			foreach ($this->plugins as $plugin => $models) {
				foreach ($models as $model => $values) {
					// check if it's valid
					$isValid = true;
					$invalidReason = [];

					if (empty($values['live'])) {
						$isValid = false;
						$invalidReason[] = 'There\'s no live key on the array';
					}

					if (empty($values['fields'])) {
						$isValid = false;
						$invalidReason[] = 'No fields defined in the array';
					}

					if (!$isValid) {
						$this->resultsTable['invalid'][] = [
							$plugin,
							$model,
							implode(" && ", $invalidReason),
						];
						continue;
					}

					$truncate = (!empty($values['truncate'])) ? $values['truncate'] : false;

					$this->resultsTable['valid'][] = [
						$plugin,
						$model,
						(!empty($values['seeds'])) ? $values['seeds'] : 10,
						json_encode($values['fields']),
						($truncate) ? 'Yes' : 'No',
					];

					$this->results[] = [
						'plugin' => $plugin,
						'model' => $model,
						'values' => $values
					];
				}
			}
		}

		return $this->resultsTable['valid'];
	}

	private function __displayTable() {
		if (count($this->resultsTable['valid']) > 1) {
			$this->out('These plugin/models will be seeded');
			$this->helper('table')->output($this->resultsTable['valid']);
			$this->hr(1);
		}

		if (count($this->resultsTable['invalid']) > 1) {
			$this->out('These plugin/models will not be seeded');
			$this->helper('table')->output($this->resultsTable['invalid']);
			$this->hr(1);
		}
	}
}
