<?php
/**
 * SearchableHelper
 *
 * @uses AppHelper
 * @package
 * @version $id$
 * @copyright See licence
 * @author Paul Connolley {Connrs] <shunuk@gmail.com>
 * @license MIT Licence <http://www.opensource.org/licenses/mit-license.php>
 */
class SearchableHelper extends Helper {

	public $helpers = array("Html", "EvInflector.InflectorExt", "Routable.Route");

	/**
	 * viewLink
	 *
	 * @param mixed   $result
	 * @param array 	Array of the plugin references for models
	 * @access public
	 * @return void
	 */
	public function viewLink($result, $pluginRef) {
		$modelFull = $model = $result["SearchIndex"]["model"];

		$Model = EvClassRegistry::init($modelFull);
		$displayField = $Model->displayField;
		$options = array();

		// check if the result actually has a url / link to link out to instead of linking to 'view'
		if (isset($result[$Model->alias]['link'])) {

			$url = $result[$Model->alias]['link'];
			$options['target'] = '_blank';

		} elseif (isset($result[$Model->alias]['url'])) {

			$url = $result[$Model->alias]['url'];
			$options['target'] = '_blank';

		} else {

			// nope, lets try and load the 'view'
			$plugin = (isset($pluginRef[$Model->alias])) ? $pluginRef[$Model->alias] : false;
			$id = $result["SearchIndex"]["association_key"];

			$url = $this->Route->getItemRoute($plugin, $Model->alias);
			if (! empty($url)) {
				$url[] = $id;
			} else {
				$controller = Inflector::tableize($Model->alias);
				$action = "view";

				$url = array(
					'plugin' => (isset($pluginRef[$Model->alias])) ? $this->InflectorExt->underscore($pluginRef[$Model->alias]) : false, // check if it's a plugin model and assign as needed
					'controller' => $controller,
					'action' => $action,
					$id
				);
			}
		}

		// Try and work out the title
		if ($displayField == 'id') {
			$title = $this->InflectorExt->camelToHumanize($Model->alias);
		} else {
			$title = $result[$Model->alias][$displayField];
		}

		return $this->Html->link(
			$title,
			$url,
			$options
		);
	}
}

