<?php

App::uses('CakeEventListener', 'Event');
App::uses('CakeLog', 'Log');

class SearchableListenForToggleActiveListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.afterToggle' => 'checkActive'
		);
	}

/**
 * Updates the items active status depending on it's associated item if is_active was toggled
 *
 * @param  CakeEvent $Event [description]
 * @return bool
 */
	public function checkActive(CakeEvent $Event) {
		//
		$Model = $Event->data['model'];
		$field = $Event->data['field'];
		$data = $Model->findById( $Event->data['id'] );

		$ModelAlias = EvClassRegistry::getNameFromModel($Model);

		if ($field == '`' . $Model->alias . '`.`is_active`') {
			$SearchIndex = EvClassRegistry::init('Searchable.SearchIndex');
			$SearchIndex->updateAll([
				'SearchIndex.is_active' => $data[$Model->alias]['is_active']
			], [
				'SearchIndex.model' => $ModelAlias,
				'SearchIndex.association_key' => $data[$Model->alias]['id']
			]);
		}

		return true;
	}
}
