<?php
/**
 * SearchableHelper
 *
 * @uses AppHelper
 * @package
 * @version $id$
 * @copyright See licence
 * @author Paul Connolley {Connrs] <shunuk@gmail.com>
 * @license MIT Licence <http://www.opensource.org/licenses/mit-license.php>
 */
class SearchableHelper extends Helper {
	var $helpers = array("Html", "InflectorExt");

	/**
	 * viewLink
	 *
	 * @param mixed   $result
	 * @param array 	Array of the plugin references for models
	 * @access public
	 * @return void
	 */
	public function viewLink($result, $pluginRef)
	{
		$modelFull = $model = $result["SearchIndex"]["model"];

		if (isset($pluginRef[$model])) {

			$modelFull = $pluginRef[$model] . '.' . $model;
		}

		$Model = ClassRegistry::init($modelFull);
		$displayField = $Model->displayField;
		$options = array();

		// check if the result actually has a url / link to link out to instead of linking to 'view'
		if (isset($result[$model]['link'])) {

			$url = $result[$model]['link'];
			$options['target'] = '_blank';

		} elseif (isset($result[$model]['url'])) {

			$url = $result[$model]['url'];
			$options['target'] = '_blank';

		} else {

			// nope, lets try and load the 'view'
			$controller = Inflector::tableize($model);
			$action = "view";
			$id = $result["SearchIndex"]["association_key"];

			$url = array(
				'plugin' => (isset($pluginRef[$model])) ? $this->InflectorExt->underscore($pluginRef[$model]) : false, // check if it's a plugin model and assign as needed
				'controller' => $controller,
				'action' => $action,
				$id
			);
		}

		// Try and work out the title
		if ($displayField == 'id') {
			$title = $this->InflectorExt->camelToHumanize($model);
		} else {
			$title = $result[$model][$displayField];
		}

		return $this->Html->link(
			$title,
			$url,
			$options
		);
	}
}

