<?php

App::uses('SearchableAppModel', 'Searchable.Model');

class SearchIndex extends SearchableAppModel {
    public $name = 'SearchIndex';
    public $useTable = 'search_indices';
    private $models = array();

    private function bindTo($model) {

        list($pluginName, $modelName) = pluginSplit($model);

        $this->bindModel(
            array(
                'belongsTo' => array(
                    $modelName => array(
                        'className' => $model,
                        'conditions' => 'SearchIndex.model = \''.$modelName.'\'',
                        'foreignKey' => 'association_key'
                    )
                )
            ),false
        );
    }

    public function searchModels($models = array()) {
        if (is_string($models)) $models = array($models);
        $this->models = $models;
        foreach ($models as $model) {
            $this->bindTo($model);
        }
    }

    public function beforeFind($queryData) {
        $models_condition = false;
        if (!empty($this->models)) {
            $models_condition = array();
            foreach ($this->models as $model) {
                $Model = ClassRegistry::init($model);
                $models_condition[] = $this->relationize($model) . '.'.$Model->primaryKey.' IS NOT NULL';
            }
        }

        if (isset($queryData['conditions'])) {
            if ($models_condition) {
                if (is_string($queryData['conditions'])) {
                    $queryData['conditions'] .= ' AND (' . join(' OR ',$models_condition) . ')';
                } else {
                    $queryData['conditions'][] = array('OR' => $models_condition);
                }
            }
        } else {
            if ($models_condition) {
                $queryData['conditions'][] = array('OR' => $models_condition);
            }
        }
        return $queryData;
    }

    public function afterFind($results, $primary = false) {
        if ($primary) {
            foreach($results as $x => $result) {
                if (!empty($result['SearchIndex']['model'])) {
                    $Model = ClassRegistry::init($result['SearchIndex']['model']);
                    $results[$x]['SearchIndex']['displayField'] = $Model->displayField;
                }
            }
        }
        return $results;
    }

    public function fuzzyize($query) {
        $query = preg_replace('/\s+/', '\s*', $query);
        return $query;
    }

    /**
     * given the model list (including plugin.model types) convert into relationship names.
     * mainly for plugin models, removes the plugin name and period. PluginName.MyModel becomes MyModel.
     *
     * @param   array|string       array of models we are searching on or single model to change
     * @return  array|string       array of all the relationships for the contains or changed model
     */
    public function relationize($models)
    {
        if (is_array($models)) {

            foreach ($models as $key => $model) {

                list($pluginName, $modelName) = pluginSplit($model);
                $models[$key] = $modelName;
            }

        } else {

            list($pluginName, $modelName) = pluginSplit($models);
            $models = $modelName;
        }

        return $models;
    }

    /**
     * given the model list, return a reference for models that are in plugins
     *
     * @param   array   array of models
     * @return  array   array containing models as the keys with the plugin name as the value
     */
    public function pluginReference($models)
    {
        $reference = array();
        foreach ($models as $key => $model) {

            list($pluginName, $modelName) = pluginSplit($model);

            if (! empty($pluginName)) {

                $reference[$modelName] = $pluginName;
            }
        }

        return $reference;
    }

}