<?php if (isset($sectionCount) && $sectionCount > 1): ?>
	<?php $this->Html->script('Searchable.search-results.js', array('inline' => false)); ?>
	<?php $this->Html->css('Searchable.search-results.css', array('inline' => false)); ?>
<?php endif; ?>

<div class='row'>

	<?php if (isset($sectionCount) && $sectionCount > 1): ?>
		<div class='col-2'>
			<div class='menu'>
				<div class='menu__heading h3'><i class='fa fa-left fa-search'></i> Search Results</div>
				<ul>
					<?php $first = ' results-active'; ?>
					<?php foreach ($formattedResults as $model => $results): ?>

						<li>
							<?php
								echo $this->Html->link(
									'<i class="fa fa-left fa-angle-right"></i> ' . $this->InflectorExt->camelToHumanize($model),
									'#' . $model . '-results',
									array(
										'escape' => false,
										'class' => 'search-model' . $first
									)
								);
								$first = '';
							?>
						</li>

					<?php endforeach; ?>
				</ul>
			</div>
		</div>
	<?php endif; ?>


	<div class='<?php echo (isset($sectionCount) && $sectionCount > 1) ? 'col-8' : 'col-10'; ?>'>

		<div class="search-results">

			<?php if (isset($formattedResults) && ! empty($formattedResults)): ?>

				<?php foreach ($formattedResults as $model => $results): ?>
					<?php list($plugin,$model) = pluginSplit($model); ?>

					<div class="model-results" id="<?php echo $model . '-results'; ?>">
						<h1>
							<i class='fa fa-left fa-search'></i>
							Search Results:
							<span><?php echo $this->InflectorExt->camelToHumanize($model); ?></span>
						</h1>

						<?php if (! empty($results)): ?>

							<ul>
								<?php foreach ($results as $result): ?>
									<li>

										<?php echo $this->Searchable->viewLink($result, $pluginRef); ?>

									</li>
								<?php endforeach; ?>
							</ul>

						<?php else: ?>

							<p>There are no results to display</p>

						<?php endif; ?>

					</div>

				<?php endforeach; ?>

			<?php elseif (isset($noResults) && $noResults): ?>

				<h1>
					<i class='fa fa-left fa-search'></i>
					No matches
				</h1>

				<p>There are no items that matched your search term</p>

			<?php endif; ?>

			<?php if (!empty($paginated) && ($this->Paginator->hasPrev() || $this->Paginator->hasNext())): ?>
				<div class="paginator-container">
					<?= $this->element('paginator'); ?>
				</div>
			<?php endif; ?>

		</div>
	</div>
</div>
