# EvSagePay

## Config

```<?php
   
   $config = [
   	'EvSagePay' => [
   		'SagePayDirect' => [
   			'accountType' => 'M',
   			'live' => [
   				'vendor' => '',
   				//'profile' => 'LOW',
   			],
   			'dev' => [
   				'vendor' => '',
   			]
   		],
   		'SagePayServer' => [
   			// completeUrl is a fallback for if EvCheckout is not available.
   			// Otherwise OrdersManager::getCompleteUrl() will be used instead.
   			'completeUrl' => '',
   			'live' => [
   				'vendor' => ''
   			],
   			'dev' => [
   				'vendor' => ''
   			]
   		]
   	]
   ];
```

| Param | Description | Mandatory | Default |
|-------|---------|---------|---------|
| vendor | Sagepay Vendor | Yes | n/a |
| completeUrl | Callback url for completed payments |  Yes       | n/a |
| accountType  |  Indicates if it is a user present or telephone order, Set to 'M' for MOTO/Telephone payments  | No | Defaults to user present mode |
| profile     |  Set to 'LOW' if using offsite payment in an embedded Iframe       |  No | Normal |


## Requirements
Requirements for sagepay payments
* Card details (doesn't need start date)
* Billing Address (address 1, city, country, postcode necessary)

## setupPayment - extras

### CreditCard
Provide the credit card details by the following fields under 'CreditCard' in the extras array provided to the setupPayment method.

* card_holder_name (This is split by spaces to get the first and last name)
* card_number
* start_month
* start_year
* expiry_month
* expiry_year
* security_number

start_month and start_year will be set to null if not provided.

### delivery
The delivery address is used by default as the billing address. The component will need to be overridden if you want to have a seperate billing address. The address needs to be provided in the following format under 'delivery' in the extras array. If using the address book plugin then the formatting is the same.

* Address - address1
* Address - address2
* Address - city
* Address - post_code

States are set to empty assuming UK sites won't need them. There isn't an option for county so it doesn't need to be passed in. Country defaults to UK.

### user
The user is used to set the email. Phone number is set to empty by default. Is standard Auth user structure. User needs to be provided in the following format under 'user'  in the extras array.

* User - email

## Testing
The following link is a list of SagePay's test cards:
http://www.sagepay.co.uk/support/12/36/test-card-details-for-your-test-transactions

Note the address details, the address "88" and postcode "412" need to be provided to pass the fraud checks.

When using `SagePayOffsite`, the gateway needs a publicly accessible notification url. You'll need to make sure `/ev_sage_pay/sage_pay_offsite/notification` can be called from outside the office network and basic auth is turned off on this url.

### Testing live payments on UAT

Enable production environment on UAT with `Configure::write('app.environment', 'PRODUCTION');` in your `bootstrap.php`

SagePay 3D Secure needs to be able to access the site the payment came from.  As requests to UAT from outside of the evoluted network require basic auth (as of 26 Mar 2020), any callbacks from SagePay will fail.  Add `->set('vhost_parameters', ['allow_sage_pay' => true])` to your host in the project's `deploy.php` to bypass this.

Example: https://git.evoluted.net/pinelog/pinelodge-holidays/-/blob/1f2851691670498364f0a47cca442492edfdbf77/deploy.php#L62

## Events
`EvSagePay.Component.SagePayOffsite.transactionFailed` Dispatched when using `SagePayOffsite` and a payment fails. Can be used to update orders in the DB.

## SagePayOffsite

Specific quirks for SagePay Offsite

### Return URL
While a return URL is required to be passed to `TransactionsComponent::takePayment()`, it cannot be used by `SagePayOffsite` as the return URL is requested directly by their server in a notify callback which doesn't have access to the current session. Currently the plugin depends on `EvCheckout.OrderManagerComponent::getCompleteUrl()` to build a return URL, however, if `EvCheckout` is not installed in your project, you can instead make use of the fallback `completeUrl` parameter in your `app/Config/Plugin/ev_sage_pay.php`.

**An `Exception` will be thrown if neither are available!**

### Transaction Description
This can be overridden by adding a `transactionDescription` field to the `extras` parameter of the `TransactionsComponent::takePayment()` call.

## Troubleshooting

