<?php
App::uses('AppController', 'Controller');
class SagePayController extends AppController {

	public $components = array(
		'EvSagePay.SagePay'
	);

	public function beforeFilter() {
		$this->Auth->allow(
			array(
				'secure3dResponse',
				'secure3dRedirect',
				'secure3dCallback',
			)
		);

		parent::beforeFilter();
	}

	public function secure3dResponse() {
		$this->SagePay->setup();
		$this->SagePay->process3dSecure();
	}

	public function secure3dRedirect() {
		$data = $this->Session->read('SagePay.3dSecure');
		$creq = $this->Session->read('SagePay.creq');
		$vpstxid = $this->Session->read('SagePay.vpstxid');

		$callbackUrl = Router::url(
			array(
                'action' => '3dcallback',
				'?' => array(
					'vendorTxCode' => $data['data']['vendorTxCode'],
					'VPSTxId' => $vpstxid,
				),
            ),
			true
		);

		$this->set(
			compact(
				array(
					'data',
					'callbackUrl',
					'creq',
					'vpstxid',
				)
			)
		);

		$this->layout = 'iframe';
	}

	public function secure3DCallback() {
		$transactionId = null;
		if (! empty($this->request->query('transactionId'))) {
			$transactionId = $this->request->query('transactionId');
		}

		// Where possible pull the values from the transaction data table, but
		// fallback to the session. This adds an extra layer of redundancy.
		$transactionData = $this->SagePay->readStoredTransactionData($transactionId);

		$vpsTxId = $this->Session->read('SagePay.vpstxid');
		if (! empty($transactionData['vpstxid'])) {
			$vpsTxId = $transactionData['vpstxid'];
		}

		$returnUrl = $this->Session->read('SagePay.returnUrl');
		if (! empty($transactionData['returnUrl'])) {
			$returnUrl = $transactionData['returnUrl'];
		}

		// Fallback as a last resort we push back to the homepage as otherwise
		// you could be stuck in a loop if we keep posting back to ourselves
		if (empty($returnUrl)) {
			$returnUrl = '/';
		}

		$cres = $this->request->data['cres'];
		$this->set(compact( 'cres', 'returnUrl', 'cres', 'vpsTxId'));

		$this->layout = 'iframe';
	}

}
