<?php
App::uses('AppController', 'Controller');
class SagePayController extends AppController {

	public $components = ['EvSagePay.SagePay'];

/**
 * beforeFilter
 *
 * @return CakeResponse|void|null
 */
	public function beforeFilter() {
		$this->Auth->allow([
			'secure3dResponse',
			'secure3dRedirect',
			'secure3dCallback',
		]);

		parent::beforeFilter();
	}

/**
 * secure3dResponse (Legacy method for older versions of SagePay)
 *
 * @return void
 */
	public function secure3dResponse() {
		$this->SagePay->setup();
		$this->SagePay->process3dSecure();
	}

/**
 * secure3dRedirect - Handles showing a basic form page to redirect the user to/from SagePay
 *
 * @return void
 */
	public function secure3dRedirect() {
		$data = $this->Session->read('SagePay.3dSecure');
		$this->set(compact('data'));

		$this->layout = 'iframe';
	}

/**
 * secure3dCallback - Handles the callback from SagePay and shows an automatically posted form to complete the transaction
 *
 * @return void
 */
	public function secure3DCallback() {
		$transactionId = $this->request->query('transactionId') ?? null;

		// Where possible pull the values from the transaction data table, but
		// fallback to the session. This adds an extra layer of redundancy.
		$transactionData = $this->SagePay->readStoredTransactionData($transactionId);
		$vpsTxId = $transactionData['vpstxid'] ?? $this->Session->read('SagePay.vpstxid');
		$returnUrl = $transactionData['returnUrl'] ?? $this->Session->read('SagePay.returnUrl');

		// Fallback as a last resort we push back to the homepage as otherwise
		// you could be stuck in a loop if we keep posting back to ourselves
		if (empty($returnUrl)) {
			$returnUrl = '/';
		}

		$cres = $this->request->data['cres'];
		$this->set(compact( 'cres', 'returnUrl', 'cres', 'vpsTxId'));

		$this->layout = 'iframe';
	}
}
