<?php

App::uses('AppHelper', 'View/Helper');
App::uses('RouterUtil', 'Routable.Lib');

class RouteHelper extends AppHelper
{

	/**
	 * magic method to check if the function exists in the lib file and call it if so
	 * if not, it will try and return the string we were trying to Inflect
	 * if it can't do that, it will just return false
	 *
	 */
	public function __call($name, $arguments)
	{
		if (method_exists('RouterUtil', $name)) {

			return call_user_func_array('RouterUtil::' . $name, $arguments);
		}

		// we can't find it, return false
		return false;
	}
}